/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.support;

import io.github.sashirestela.cleverclient.annotation.StreamType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class ReturnType {
    private static final String ASYNC = "java.util.concurrent.CompletableFuture";
    private static final String STREAM = "java.util.stream.Stream";
    private static final String LIST = "java.util.List";
    private static final String INPUTSTREAM = "java.io.InputStream";
    private static final String STRING = "java.lang.String";
    private static final String EVENT = "io.github.sashirestela.cleverclient.Event";
    private static final String REGEX = "[<>]";
    private static final String JAVA_PCK = "java";
    private String fullClassName;
    private String[] returnTypeArray;
    private int size;
    private int firstIndex;
    private int lastIndex;
    private int prevLastIndex;
    private Map<String, Class<?>> classByEvent;

    public ReturnType(String fullClassName) {
        this.fullClassName = fullClassName;
        this.returnTypeArray = fullClassName.split(REGEX, 0);
        this.size = this.returnTypeArray.length;
        this.firstIndex = 0;
        this.lastIndex = this.size - 1;
        this.prevLastIndex = this.lastIndex - 1;
    }

    public ReturnType(Method method) {
        this(method.getGenericReturnType().getTypeName());
        this.setClassByEventIfExists(method);
    }

    private void setClassByEventIfExists(Method method) {
        if (method.isAnnotationPresent(StreamType.StreamTypeArray.class)) {
            this.classByEvent = this.calculateClassByEvent(method.getDeclaredAnnotation(StreamType.StreamTypeArray.class).value());
        } else if (method.isAnnotationPresent(StreamType.class)) {
            this.classByEvent = this.calculateClassByEvent(new StreamType[]{method.getDeclaredAnnotation(StreamType.class)});
        } else {
            Optional<? extends Annotation> innerStreamTypeList = this.getInnerAnnotationIfExists(method, StreamType.StreamTypeArray.class);
            if (innerStreamTypeList.isPresent()) {
                this.classByEvent = this.calculateClassByEvent(innerStreamTypeList.get().annotationType().getDeclaredAnnotation(StreamType.StreamTypeArray.class).value());
            } else {
                Optional<? extends Annotation> innerStreamType = this.getInnerAnnotationIfExists(method, StreamType.class);
                if (innerStreamType.isPresent()) {
                    this.classByEvent = this.calculateClassByEvent(new StreamType[]{innerStreamType.get().annotationType().getDeclaredAnnotation(StreamType.class)});
                }
            }
        }
    }

    private Optional<? extends Annotation> getInnerAnnotationIfExists(Method method, Class<? extends Annotation> clazz) {
        return Arrays.stream(method.getDeclaredAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(clazz)).findFirst();
    }

    private Map<String, Class<?>> calculateClassByEvent(StreamType[] streamTypeList) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        Arrays.stream(streamTypeList).forEach(streamType -> Arrays.stream(streamType.events()).forEach(event -> map.put((String)event, streamType.type())));
        return map;
    }

    public String toString() {
        return this.fullClassName;
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public Map<String, Class<?>> getClassByEvent() {
        return this.classByEvent;
    }

    public Class<?> getBaseClass() {
        return this.getClass(this.lastIndex);
    }

    public Class<?> getGenericClassIfExists() {
        return this.isGeneric() ? this.getClass(this.prevLastIndex) : null;
    }

    private Class<?> getClass(int index) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.returnTypeArray[index]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    public Category category() {
        if (this.isAsync()) {
            return this.asyncCategory();
        }
        return this.syncCategory();
    }

    private Category asyncCategory() {
        if (this.isStream()) {
            if (this.isEvent()) {
                return Category.ASYNC_STREAM_EVENT;
            }
            return Category.ASYNC_STREAM;
        }
        if (this.isList()) {
            return Category.ASYNC_LIST;
        }
        if (this.isGeneric()) {
            return Category.ASYNC_GENERIC;
        }
        if (this.isCustom()) {
            return Category.ASYNC_CUSTOM;
        }
        if (this.isBinary()) {
            return Category.ASYNC_BINARY;
        }
        if (this.isPlainText()) {
            return Category.ASYNC_PLAIN_TEXT;
        }
        return null;
    }

    private Category syncCategory() {
        if (this.isStream()) {
            if (this.isEvent()) {
                return Category.SYNC_STREAM_EVENT;
            }
            return Category.SYNC_STREAM;
        }
        if (this.isList()) {
            return Category.SYNC_LIST;
        }
        if (this.isGeneric()) {
            return Category.SYNC_GENERIC;
        }
        if (this.isCustom()) {
            return Category.SYNC_CUSTOM;
        }
        if (this.isBinary()) {
            return Category.SYNC_BINARY;
        }
        if (this.isPlainText()) {
            return Category.SYNC_PLAIN_TEXT;
        }
        return null;
    }

    public boolean isAsync() {
        return this.size > 1 && ASYNC.equals(this.returnTypeArray[this.firstIndex]);
    }

    public boolean isStream() {
        return this.size > 1 && STREAM.equals(this.returnTypeArray[this.prevLastIndex]);
    }

    private boolean isList() {
        return this.size > 1 && LIST.equals(this.returnTypeArray[this.prevLastIndex]);
    }

    private boolean isGeneric() {
        return (this.isAsync() && this.size > 2 || !this.isAsync() && this.size > 1) && !this.returnTypeArray[this.prevLastIndex].startsWith(JAVA_PCK);
    }

    private boolean isCustom() {
        return !this.isInputStream() && !this.isString() && !this.isEvent() && (this.size == 1 || this.size == 2 && this.isAsync());
    }

    private boolean isBinary() {
        return this.isInputStream() && (this.size == 1 || this.size == 2 && this.isAsync());
    }

    private boolean isPlainText() {
        return this.isString() && (this.size == 1 || this.size == 2 && this.isAsync());
    }

    public boolean isInputStream() {
        return INPUTSTREAM.equals(this.returnTypeArray[this.lastIndex]);
    }

    private boolean isString() {
        return STRING.equals(this.returnTypeArray[this.lastIndex]);
    }

    private boolean isEvent() {
        return EVENT.equals(this.returnTypeArray[this.lastIndex]);
    }

    public static enum Category {
        ASYNC_STREAM_EVENT,
        ASYNC_STREAM,
        ASYNC_LIST,
        ASYNC_GENERIC,
        ASYNC_CUSTOM,
        ASYNC_BINARY,
        ASYNC_PLAIN_TEXT,
        SYNC_STREAM_EVENT,
        SYNC_STREAM,
        SYNC_LIST,
        SYNC_GENERIC,
        SYNC_CUSTOM,
        SYNC_BINARY,
        SYNC_PLAIN_TEXT;

    }
}

