/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.sashirestela.cleverclient.client.HttpClientAdapter;
import io.github.sashirestela.cleverclient.client.JavaHttpClientAdapter;
import io.github.sashirestela.cleverclient.http.HttpProcessor;
import io.github.sashirestela.cleverclient.http.HttpRequestData;
import io.github.sashirestela.cleverclient.http.HttpResponseData;
import io.github.sashirestela.cleverclient.retry.RetryConfig;
import io.github.sashirestela.cleverclient.retry.RetryableRequest;
import io.github.sashirestela.cleverclient.support.Configurator;
import io.github.sashirestela.cleverclient.util.CommonUtil;
import io.github.sashirestela.cleverclient.websocket.Action;
import io.github.sashirestela.cleverclient.websocket.JavaHttpWebSocketAdapter;
import io.github.sashirestela.cleverclient.websocket.WebSocketAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleverClient {
    private static final Logger logger = LoggerFactory.getLogger(CleverClient.class);
    private final String baseUrl;
    private final Map<String, String> headers;
    private final Consumer<Object> bodyInspector;
    private final UnaryOperator<HttpRequestData> requestInterceptor;
    private final UnaryOperator<HttpResponseData> responseInterceptor;
    private final RetryConfig retryConfig;
    private final HttpClientAdapter clientAdapter;
    private final HttpProcessor httpProcessor;

    public CleverClient(@NonNull String baseUrl, Map<String, String> headers, Consumer<Object> bodyInspector, UnaryOperator<HttpRequestData> requestInterceptor, UnaryOperator<HttpResponseData> responseInterceptor, RetryConfig retryConfig, HttpClientAdapter clientAdapter, ObjectMapper objectMapper, List<String> endsOfStream) {
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        this.baseUrl = baseUrl;
        this.headers = Optional.ofNullable(headers).orElse(Map.of());
        this.bodyInspector = bodyInspector;
        this.requestInterceptor = requestInterceptor;
        this.responseInterceptor = responseInterceptor;
        this.retryConfig = retryConfig;
        this.clientAdapter = Optional.ofNullable(clientAdapter).orElseGet(() -> new JavaHttpClientAdapter());
        this.clientAdapter.setRequestInterceptor(this.requestInterceptor);
        this.clientAdapter.setResponseInterceptor(this.responseInterceptor);
        if (this.retryConfig != null) {
            this.clientAdapter.setRetryableRequest(new RetryableRequest(this.retryConfig));
        }
        this.httpProcessor = HttpProcessor.builder().baseUrl(this.baseUrl).headers(CommonUtil.mapToListOfString(this.headers)).clientAdapter(this.clientAdapter).bodyInspector(this.bodyInspector).build();
        Configurator.builder().objectMapper(Optional.ofNullable(objectMapper).orElse(new ObjectMapper())).endsOfStream((Collection<? extends String>)Optional.ofNullable(endsOfStream).orElse(Arrays.asList(new String[0]))).build();
        logger.debug("CleverClient has been created.");
    }

    public <T> T create(Class<T> interfaceClass) {
        return this.httpProcessor.createProxy(interfaceClass);
    }

    @Generated
    public static CleverClientBuilder builder() {
        return new CleverClientBuilder();
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public Consumer<Object> getBodyInspector() {
        return this.bodyInspector;
    }

    @Generated
    public UnaryOperator<HttpRequestData> getRequestInterceptor() {
        return this.requestInterceptor;
    }

    @Generated
    public UnaryOperator<HttpResponseData> getResponseInterceptor() {
        return this.responseInterceptor;
    }

    @Generated
    public RetryConfig getRetryConfig() {
        return this.retryConfig;
    }

    @Generated
    public HttpClientAdapter getClientAdapter() {
        return this.clientAdapter;
    }

    @Generated
    public HttpProcessor getHttpProcessor() {
        return this.httpProcessor;
    }

    @Generated
    public static class CleverClientBuilder {
        @Generated
        private String baseUrl;
        @Generated
        private ArrayList<String> headers$key;
        @Generated
        private ArrayList<String> headers$value;
        @Generated
        private Consumer<Object> bodyInspector;
        @Generated
        private UnaryOperator<HttpRequestData> requestInterceptor;
        @Generated
        private UnaryOperator<HttpResponseData> responseInterceptor;
        @Generated
        private RetryConfig retryConfig;
        @Generated
        private HttpClientAdapter clientAdapter;
        @Generated
        private ObjectMapper objectMapper;
        @Generated
        private ArrayList<String> endsOfStream;

        @Generated
        CleverClientBuilder() {
        }

        @Generated
        public CleverClientBuilder baseUrl(@NonNull String baseUrl) {
            if (baseUrl == null) {
                throw new NullPointerException("baseUrl is marked non-null but is null");
            }
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public CleverClientBuilder header(String headerKey, String headerValue) {
            if (this.headers$key == null) {
                this.headers$key = new ArrayList();
                this.headers$value = new ArrayList();
            }
            this.headers$key.add(headerKey);
            this.headers$value.add(headerValue);
            return this;
        }

        @Generated
        public CleverClientBuilder headers(Map<? extends String, ? extends String> headers) {
            if (headers == null) {
                throw new NullPointerException("headers cannot be null");
            }
            if (this.headers$key == null) {
                this.headers$key = new ArrayList();
                this.headers$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : headers.entrySet()) {
                this.headers$key.add($lombokEntry.getKey());
                this.headers$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public CleverClientBuilder clearHeaders() {
            if (this.headers$key != null) {
                this.headers$key.clear();
                this.headers$value.clear();
            }
            return this;
        }

        @Generated
        public CleverClientBuilder bodyInspector(Consumer<Object> bodyInspector) {
            this.bodyInspector = bodyInspector;
            return this;
        }

        @Generated
        public CleverClientBuilder requestInterceptor(UnaryOperator<HttpRequestData> requestInterceptor) {
            this.requestInterceptor = requestInterceptor;
            return this;
        }

        @Generated
        public CleverClientBuilder responseInterceptor(UnaryOperator<HttpResponseData> responseInterceptor) {
            this.responseInterceptor = responseInterceptor;
            return this;
        }

        @Generated
        public CleverClientBuilder retryConfig(RetryConfig retryConfig) {
            this.retryConfig = retryConfig;
            return this;
        }

        @Generated
        public CleverClientBuilder clientAdapter(HttpClientAdapter clientAdapter) {
            this.clientAdapter = clientAdapter;
            return this;
        }

        @Generated
        public CleverClientBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        @Generated
        public CleverClientBuilder endOfStream(String endOfStream) {
            if (this.endsOfStream == null) {
                this.endsOfStream = new ArrayList();
            }
            this.endsOfStream.add(endOfStream);
            return this;
        }

        @Generated
        public CleverClientBuilder endsOfStream(Collection<? extends String> endsOfStream) {
            if (endsOfStream == null) {
                throw new NullPointerException("endsOfStream cannot be null");
            }
            if (this.endsOfStream == null) {
                this.endsOfStream = new ArrayList();
            }
            this.endsOfStream.addAll(endsOfStream);
            return this;
        }

        @Generated
        public CleverClientBuilder clearEndsOfStream() {
            if (this.endsOfStream != null) {
                this.endsOfStream.clear();
            }
            return this;
        }

        @Generated
        public CleverClient build() {
            List<String> endsOfStream;
            Map<Object, Object> headers;
            switch (this.headers$key == null ? 0 : this.headers$key.size()) {
                case 0: {
                    headers = Collections.emptyMap();
                    break;
                }
                case 1: {
                    headers = Collections.singletonMap(this.headers$key.get(0), this.headers$value.get(0));
                    break;
                }
                default: {
                    headers = new LinkedHashMap(this.headers$key.size() < 0x40000000 ? 1 + this.headers$key.size() + (this.headers$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.headers$key.size(); ++$i) {
                        headers.put(this.headers$key.get($i), this.headers$value.get($i));
                    }
                    headers = Collections.unmodifiableMap(headers);
                }
            }
            switch (this.endsOfStream == null ? 0 : this.endsOfStream.size()) {
                case 0: {
                    endsOfStream = Collections.emptyList();
                    break;
                }
                case 1: {
                    endsOfStream = Collections.singletonList(this.endsOfStream.get(0));
                    break;
                }
                default: {
                    endsOfStream = Collections.unmodifiableList(new ArrayList<String>(this.endsOfStream));
                }
            }
            return new CleverClient(this.baseUrl, headers, this.bodyInspector, this.requestInterceptor, this.responseInterceptor, this.retryConfig, this.clientAdapter, this.objectMapper, endsOfStream);
        }

        @Generated
        public String toString() {
            return "CleverClient.CleverClientBuilder(baseUrl=" + this.baseUrl + ", headers$key=" + this.headers$key + ", headers$value=" + this.headers$value + ", bodyInspector=" + this.bodyInspector + ", requestInterceptor=" + this.requestInterceptor + ", responseInterceptor=" + this.responseInterceptor + ", retryConfig=" + this.retryConfig + ", clientAdapter=" + this.clientAdapter + ", objectMapper=" + this.objectMapper + ", endsOfStream=" + this.endsOfStream + ")";
        }
    }

    public static class WebSocket {
        private final String baseUrl;
        private final Map<String, String> queryParams;
        private final Map<String, String> headers;
        private final WebSocketAdapter webSockewAdapter;
        private String fullUrl;

        public WebSocket(@NonNull String baseUrl, Map<String, String> queryParams, Map<String, String> headers, WebSocketAdapter webSockewAdapter) {
            if (baseUrl == null) {
                throw new NullPointerException("baseUrl is marked non-null but is null");
            }
            this.baseUrl = baseUrl;
            this.queryParams = Optional.ofNullable(queryParams).orElse(Map.of());
            this.headers = Optional.ofNullable(headers).orElse(Map.of());
            this.webSockewAdapter = Optional.ofNullable(webSockewAdapter).orElseGet(() -> new JavaHttpWebSocketAdapter());
            this.fullUrl = this.buildFullUrl();
        }

        private String buildFullUrl() {
            return this.baseUrl + CommonUtil.stringMapToUrl(this.queryParams);
        }

        public CompletableFuture<Void> connect() {
            return this.webSockewAdapter.connect(this.fullUrl, this.headers);
        }

        public CompletableFuture<Void> send(String message) {
            return this.webSockewAdapter.send(message);
        }

        public void close() {
            this.webSockewAdapter.close();
        }

        public void onMessage(Consumer<String> callback) {
            this.webSockewAdapter.onMessage(callback);
        }

        public void onOpen(Action callback) {
            this.webSockewAdapter.onOpen(callback);
        }

        public void onClose(BiConsumer<Integer, String> callback) {
            this.webSockewAdapter.onClose(callback);
        }

        public void onError(Consumer<Throwable> callback) {
            this.webSockewAdapter.onError(callback);
        }

        @Generated
        public static WebSocketBuilder builder() {
            return new WebSocketBuilder();
        }

        @Generated
        public String getBaseUrl() {
            return this.baseUrl;
        }

        @Generated
        public Map<String, String> getQueryParams() {
            return this.queryParams;
        }

        @Generated
        public Map<String, String> getHeaders() {
            return this.headers;
        }

        @Generated
        public WebSocketAdapter getWebSockewAdapter() {
            return this.webSockewAdapter;
        }

        @Generated
        public String getFullUrl() {
            return this.fullUrl;
        }

        @Generated
        public static class WebSocketBuilder {
            @Generated
            private String baseUrl;
            @Generated
            private ArrayList<String> queryParams$key;
            @Generated
            private ArrayList<String> queryParams$value;
            @Generated
            private ArrayList<String> headers$key;
            @Generated
            private ArrayList<String> headers$value;
            @Generated
            private WebSocketAdapter webSockewAdapter;

            @Generated
            WebSocketBuilder() {
            }

            @Generated
            public WebSocketBuilder baseUrl(@NonNull String baseUrl) {
                if (baseUrl == null) {
                    throw new NullPointerException("baseUrl is marked non-null but is null");
                }
                this.baseUrl = baseUrl;
                return this;
            }

            @Generated
            public WebSocketBuilder queryParam(String queryParamKey, String queryParamValue) {
                if (this.queryParams$key == null) {
                    this.queryParams$key = new ArrayList();
                    this.queryParams$value = new ArrayList();
                }
                this.queryParams$key.add(queryParamKey);
                this.queryParams$value.add(queryParamValue);
                return this;
            }

            @Generated
            public WebSocketBuilder queryParams(Map<? extends String, ? extends String> queryParams) {
                if (queryParams == null) {
                    throw new NullPointerException("queryParams cannot be null");
                }
                if (this.queryParams$key == null) {
                    this.queryParams$key = new ArrayList();
                    this.queryParams$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends String> $lombokEntry : queryParams.entrySet()) {
                    this.queryParams$key.add($lombokEntry.getKey());
                    this.queryParams$value.add($lombokEntry.getValue());
                }
                return this;
            }

            @Generated
            public WebSocketBuilder clearQueryParams() {
                if (this.queryParams$key != null) {
                    this.queryParams$key.clear();
                    this.queryParams$value.clear();
                }
                return this;
            }

            @Generated
            public WebSocketBuilder header(String headerKey, String headerValue) {
                if (this.headers$key == null) {
                    this.headers$key = new ArrayList();
                    this.headers$value = new ArrayList();
                }
                this.headers$key.add(headerKey);
                this.headers$value.add(headerValue);
                return this;
            }

            @Generated
            public WebSocketBuilder headers(Map<? extends String, ? extends String> headers) {
                if (headers == null) {
                    throw new NullPointerException("headers cannot be null");
                }
                if (this.headers$key == null) {
                    this.headers$key = new ArrayList();
                    this.headers$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends String> $lombokEntry : headers.entrySet()) {
                    this.headers$key.add($lombokEntry.getKey());
                    this.headers$value.add($lombokEntry.getValue());
                }
                return this;
            }

            @Generated
            public WebSocketBuilder clearHeaders() {
                if (this.headers$key != null) {
                    this.headers$key.clear();
                    this.headers$value.clear();
                }
                return this;
            }

            @Generated
            public WebSocketBuilder webSockewAdapter(WebSocketAdapter webSockewAdapter) {
                this.webSockewAdapter = webSockewAdapter;
                return this;
            }

            @Generated
            public WebSocket build() {
                Map<String, String> headers;
                Map<String, String> queryParams;
                switch (this.queryParams$key == null ? 0 : this.queryParams$key.size()) {
                    case 0: {
                        queryParams = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        queryParams = Collections.singletonMap(this.queryParams$key.get(0), this.queryParams$value.get(0));
                        break;
                    }
                    default: {
                        queryParams = new LinkedHashMap(this.queryParams$key.size() < 0x40000000 ? 1 + this.queryParams$key.size() + (this.queryParams$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.queryParams$key.size(); ++$i) {
                            queryParams.put(this.queryParams$key.get($i), this.queryParams$value.get($i));
                        }
                        queryParams = Collections.unmodifiableMap(queryParams);
                    }
                }
                switch (this.headers$key == null ? 0 : this.headers$key.size()) {
                    case 0: {
                        headers = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        headers = Collections.singletonMap(this.headers$key.get(0), this.headers$value.get(0));
                        break;
                    }
                    default: {
                        headers = new LinkedHashMap(this.headers$key.size() < 0x40000000 ? 1 + this.headers$key.size() + (this.headers$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.headers$key.size(); ++$i) {
                            headers.put(this.headers$key.get($i), this.headers$value.get($i));
                        }
                        headers = Collections.unmodifiableMap(headers);
                    }
                }
                return new WebSocket(this.baseUrl, queryParams, headers, this.webSockewAdapter);
            }

            @Generated
            public String toString() {
                return "CleverClient.WebSocket.WebSocketBuilder(baseUrl=" + this.baseUrl + ", queryParams$key=" + this.queryParams$key + ", queryParams$value=" + this.queryParams$value + ", headers$key=" + this.headers$key + ", headers$value=" + this.headers$value + ", webSockewAdapter=" + this.webSockewAdapter + ")";
            }
        }
    }
}

