/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.http;

import io.github.sashirestela.cleverclient.http.HttpConnector;
import io.github.sashirestela.cleverclient.http.HttpRequestData;
import io.github.sashirestela.cleverclient.http.URLBuilder;
import io.github.sashirestela.cleverclient.metadata.InterfaceMetadata;
import io.github.sashirestela.cleverclient.metadata.InterfaceMetadataStore;
import io.github.sashirestela.cleverclient.support.ContentType;
import io.github.sashirestela.cleverclient.support.ReturnType;
import io.github.sashirestela.cleverclient.util.JsonUtil;
import io.github.sashirestela.cleverclient.util.ReflectUtil;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProcessor
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(HttpProcessor.class);
    private final String baseUrl;
    private final List<String> headers;
    private final HttpClient httpClient;
    private final UnaryOperator<HttpRequestData> requestInterceptor;
    private final Consumer<Object> bodyInspector;

    public <T> T createProxy(Class<T> interfaceClass) {
        InterfaceMetadataStore.one().save(interfaceClass);
        T proxy = ReflectUtil.createProxy(interfaceClass, this);
        logger.debug("Created Instance : {}", (Object)interfaceClass.getSimpleName());
        return proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        logger.debug("Invoked Method : {}.{}()", (Object)method.getDeclaringClass().getSimpleName(), (Object)method.getName());
        if (method.isDefault()) {
            return MethodHandles.lookup().findSpecial(method.getDeclaringClass(), method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), method.getDeclaringClass()).bindTo(proxy).invokeWithArguments(arguments);
        }
        Object responseObject = this.resolve(method, arguments);
        logger.debug("Received Response");
        return responseObject;
    }

    private Object resolve(Method method, Object[] arguments) {
        InterfaceMetadata interfaceMetadata = InterfaceMetadataStore.one().get(method.getDeclaringClass());
        InterfaceMetadata.MethodMetadata methodMetadata = interfaceMetadata.getMethodBySignature().get(method.toString());
        String urlMethod = interfaceMetadata.getFullUrlByMethod(methodMetadata);
        String url = this.baseUrl + URLBuilder.one().build(urlMethod, methodMetadata, arguments);
        String httpMethod = methodMetadata.getHttpAnnotationName();
        ReturnType returnType = methodMetadata.getReturnType();
        ContentType contentType = methodMetadata.getContentType();
        Object body = this.getAndInspectBody(methodMetadata, arguments);
        Object bodyObject = this.getBodyObject(body, contentType);
        ArrayList<String> fullHeaders = new ArrayList<String>(this.headers);
        fullHeaders.addAll(this.calculateHeaderContentType(contentType));
        fullHeaders.addAll(interfaceMetadata.getFullHeadersByMethod(methodMetadata));
        HttpConnector httpConnector = HttpConnector.builder().httpClient(this.httpClient).url(url).httpMethod(httpMethod).returnType(returnType).bodyObject(bodyObject).contentType(contentType).headers(fullHeaders).requestInterceptor(this.requestInterceptor).build();
        return httpConnector.sendRequest();
    }

    private Object getAndInspectBody(InterfaceMetadata.MethodMetadata methodMetadata, Object[] arguments) {
        Object body;
        int bodyIndex = methodMetadata.getBodyIndex();
        Object object = body = bodyIndex >= 0 ? arguments[bodyIndex] : null;
        if (body != null && this.bodyInspector != null) {
            this.bodyInspector.accept(body);
        }
        return body;
    }

    private Object getBodyObject(Object body, ContentType contentType) {
        Object bodyObject = null;
        if (body != null) {
            if (contentType == ContentType.MULTIPART_FORMDATA) {
                bodyObject = JsonUtil.objectToMap(body);
            } else if (contentType == ContentType.APPLICATION_JSON) {
                bodyObject = JsonUtil.objectToJson(body);
            }
        }
        return bodyObject;
    }

    private List<String> calculateHeaderContentType(ContentType contentType) {
        String HEADER_CONTENT_TYPE = "Content-Type";
        ArrayList<String> headerContentType = new ArrayList<String>();
        if (contentType != null) {
            headerContentType.add("Content-Type");
            headerContentType.add(contentType.getMimeType() + contentType.getDetails());
        }
        return headerContentType;
    }

    @Generated
    HttpProcessor(String baseUrl, List<String> headers, HttpClient httpClient, UnaryOperator<HttpRequestData> requestInterceptor, Consumer<Object> bodyInspector) {
        this.baseUrl = baseUrl;
        this.headers = headers;
        this.httpClient = httpClient;
        this.requestInterceptor = requestInterceptor;
        this.bodyInspector = bodyInspector;
    }

    @Generated
    public static HttpProcessorBuilder builder() {
        return new HttpProcessorBuilder();
    }

    @Generated
    public static class HttpProcessorBuilder {
        @Generated
        private String baseUrl;
        @Generated
        private List<String> headers;
        @Generated
        private HttpClient httpClient;
        @Generated
        private UnaryOperator<HttpRequestData> requestInterceptor;
        @Generated
        private Consumer<Object> bodyInspector;

        @Generated
        HttpProcessorBuilder() {
        }

        @Generated
        public HttpProcessorBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public HttpProcessorBuilder headers(List<String> headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public HttpProcessorBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        @Generated
        public HttpProcessorBuilder requestInterceptor(UnaryOperator<HttpRequestData> requestInterceptor) {
            this.requestInterceptor = requestInterceptor;
            return this;
        }

        @Generated
        public HttpProcessorBuilder bodyInspector(Consumer<Object> bodyInspector) {
            this.bodyInspector = bodyInspector;
            return this;
        }

        @Generated
        public HttpProcessor build() {
            return new HttpProcessor(this.baseUrl, this.headers, this.httpClient, this.requestInterceptor, this.bodyInspector);
        }

        @Generated
        public String toString() {
            return "HttpProcessor.HttpProcessorBuilder(baseUrl=" + this.baseUrl + ", headers=" + this.headers + ", httpClient=" + this.httpClient + ", requestInterceptor=" + this.requestInterceptor + ", bodyInspector=" + this.bodyInspector + ")";
        }
    }
}

