/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.support;

import io.github.sashirestela.cleverclient.support.CleverClientException;
import io.github.sashirestela.cleverclient.util.Constant;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class HttpMultipart {
    private static final String DASH = "--";
    private static final String DQ = "\"";
    private static final String NL = "\r\n";
    private static final String DISPOSITION = "Content-Disposition: form-data";
    private static final String FIELD_NAME = "; name=";
    private static final String FILE_NAME = "; filename=";
    private static final String CONTENT_TYPE = "Content-Type: ";

    private HttpMultipart() {
    }

    public static List<byte[]> toByteArrays(Map<String, Object> data) {
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            byteArrays.add(HttpMultipart.toBytes(DASH + Constant.BOUNDARY_VALUE + NL));
            byteArrays.add(HttpMultipart.toBytes(DISPOSITION));
            String fieldName = entry.getKey();
            if (HttpMultipart.isFile(entry.getValue())) {
                String fileName = null;
                String mimeType = null;
                byte[] fileContent = null;
                try {
                    Path path = Path.of(new URL((String)entry.getValue()).getPath(), new String[0]);
                    fileName = path.toString();
                    mimeType = Files.probeContentType(path);
                    fileContent = Files.readAllBytes(path);
                }
                catch (IOException e) {
                    throw new CleverClientException("Error trying to read the file {0}.", fileName, e);
                }
                byteArrays.add(HttpMultipart.toBytes("; name=\"" + fieldName + "\"; filename=\"" + fileName + "\"\r\n"));
                byteArrays.add(HttpMultipart.toBytes(CONTENT_TYPE + mimeType + NL));
                byteArrays.add(HttpMultipart.toBytes(NL));
                byteArrays.add(fileContent);
                byteArrays.add(HttpMultipart.toBytes(NL));
                continue;
            }
            Object fieldValue = entry.getValue();
            boolean isFirst = true;
            if (fieldValue instanceof Collection) {
                for (Object item : (Collection)fieldValue) {
                    HttpMultipart.addIndividualField(byteArrays, fieldName + "[]", item, isFirst);
                    isFirst = false;
                }
                continue;
            }
            HttpMultipart.addIndividualField(byteArrays, fieldName, fieldValue, isFirst);
        }
        byteArrays.add(HttpMultipart.toBytes(DASH + Constant.BOUNDARY_VALUE + "--\r\n"));
        return byteArrays;
    }

    private static void addIndividualField(List<byte[]> byteArrays, String fieldName, Object fieldValue, boolean isFirst) {
        if (!isFirst) {
            byteArrays.add(HttpMultipart.toBytes(DASH + Constant.BOUNDARY_VALUE + NL));
            byteArrays.add(HttpMultipart.toBytes(DISPOSITION));
        }
        byteArrays.add(HttpMultipart.toBytes("; name=\"" + fieldName + "\"\r\n"));
        byteArrays.add(HttpMultipart.toBytes(NL));
        byteArrays.add(HttpMultipart.toBytes(fieldValue + NL));
    }

    private static byte[] toBytes(String text) {
        return text.getBytes(StandardCharsets.UTF_8);
    }

    private static boolean isFile(Object value) {
        String FILE_PROTOCOL = "file:";
        return value instanceof String && ((String)value).startsWith("file:");
    }
}

