/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.http;

import io.github.sashirestela.cleverclient.http.HttpRequestData;
import io.github.sashirestela.cleverclient.sender.HttpSender;
import io.github.sashirestela.cleverclient.sender.HttpSenderFactory;
import io.github.sashirestela.cleverclient.support.ContentType;
import io.github.sashirestela.cleverclient.support.HttpMultipart;
import io.github.sashirestela.cleverclient.support.ReturnType;
import io.github.sashirestela.cleverclient.util.CommonUtil;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnector {
    private static final Logger logger = LoggerFactory.getLogger(HttpConnector.class);
    private HttpClient httpClient;
    private String url;
    private String httpMethod;
    private ReturnType returnType;
    private Object bodyObject;
    private ContentType contentType;
    private List<String> headers;
    private UnaryOperator<HttpRequestData> requestInterceptor;

    public Object sendRequest() {
        if (this.requestInterceptor != null) {
            this.interceptRequest();
        }
        String formattedHeaders = this.printHeaders(this.headers);
        logger.debug("Http Call : {} {}", (Object)this.httpMethod, (Object)this.url);
        logger.debug("Request Headers : {}", (Object)formattedHeaders);
        HttpRequest.BodyPublisher bodyPublisher = this.createBodyPublisher(this.bodyObject, this.contentType);
        String[] headersArray = this.headers.toArray(new String[0]);
        HttpRequest httpRequest = null;
        httpRequest = headersArray.length > 0 ? HttpRequest.newBuilder().uri(URI.create(this.url)).headers(headersArray).method(this.httpMethod, bodyPublisher).build() : HttpRequest.newBuilder().uri(URI.create(this.url)).method(this.httpMethod, bodyPublisher).build();
        HttpSender httpSender = HttpSenderFactory.get().createSender(this.returnType);
        return httpSender.sendRequest(this.httpClient, httpRequest, this.returnType);
    }

    private void interceptRequest() {
        HttpRequestData httpRequestData = HttpRequestData.builder().url(this.url).body(this.bodyObject).headers(CommonUtil.listToMapOfString(this.headers)).httpMethod(this.httpMethod).contentType(this.contentType).build();
        httpRequestData = (HttpRequestData)this.requestInterceptor.apply(httpRequestData);
        this.url = httpRequestData.getUrl();
        this.bodyObject = httpRequestData.getBody();
        this.headers = CommonUtil.mapToListOfString(httpRequestData.getHeaders());
    }

    private HttpRequest.BodyPublisher createBodyPublisher(Object bodyObject, ContentType contentType) {
        HttpRequest.BodyPublisher bodyPublisher = null;
        if (contentType == null) {
            logger.debug("Request Body : (Empty)");
            bodyPublisher = HttpRequest.BodyPublishers.noBody();
        } else if (contentType == ContentType.MULTIPART_FORMDATA) {
            logger.debug("Request Body : {}", bodyObject);
            List<byte[]> bodyBytes = HttpMultipart.toByteArrays((Map)bodyObject);
            bodyPublisher = HttpRequest.BodyPublishers.ofByteArrays(bodyBytes);
        } else if (contentType == ContentType.APPLICATION_JSON) {
            logger.debug("Request Body : {}", bodyObject);
            bodyPublisher = HttpRequest.BodyPublishers.ofString((String)bodyObject);
        }
        return bodyPublisher;
    }

    private String printHeaders(List<String> headers) {
        StringBuilder print = new StringBuilder("{");
        for (int i = 0; i < headers.size(); i += 2) {
            String headerKey;
            if (i > 1) {
                print.append(", ");
            }
            String headerVal = (headerKey = headers.get(i)).equals("Authorization") ? "*".repeat(10) : headers.get(i + 1);
            print.append(headerKey + " = " + headerVal);
        }
        print.append("}");
        return print.toString();
    }

    public static HttpConnectorBuilder builder() {
        return new HttpConnectorBuilder();
    }

    public HttpConnector(HttpClient httpClient, String url, String httpMethod, ReturnType returnType, Object bodyObject, ContentType contentType, List<String> headers, UnaryOperator<HttpRequestData> requestInterceptor) {
        this.httpClient = httpClient;
        this.url = url;
        this.httpMethod = httpMethod;
        this.returnType = returnType;
        this.bodyObject = bodyObject;
        this.contentType = contentType;
        this.headers = headers;
        this.requestInterceptor = requestInterceptor;
    }

    public static class HttpConnectorBuilder {
        private HttpClient httpClient;
        private String url;
        private String httpMethod;
        private ReturnType returnType;
        private Object bodyObject;
        private ContentType contentType;
        private List<String> headers;
        private UnaryOperator<HttpRequestData> requestInterceptor;

        HttpConnectorBuilder() {
        }

        public HttpConnectorBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public HttpConnectorBuilder url(String url) {
            this.url = url;
            return this;
        }

        public HttpConnectorBuilder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public HttpConnectorBuilder returnType(ReturnType returnType) {
            this.returnType = returnType;
            return this;
        }

        public HttpConnectorBuilder bodyObject(Object bodyObject) {
            this.bodyObject = bodyObject;
            return this;
        }

        public HttpConnectorBuilder contentType(ContentType contentType) {
            this.contentType = contentType;
            return this;
        }

        public HttpConnectorBuilder headers(List<String> headers) {
            this.headers = headers;
            return this;
        }

        public HttpConnectorBuilder requestInterceptor(UnaryOperator<HttpRequestData> requestInterceptor) {
            this.requestInterceptor = requestInterceptor;
            return this;
        }

        public HttpConnector build() {
            return new HttpConnector(this.httpClient, this.url, this.httpMethod, this.returnType, this.bodyObject, this.contentType, this.headers, this.requestInterceptor);
        }

        public String toString() {
            return "HttpConnector.HttpConnectorBuilder(httpClient=" + this.httpClient + ", url=" + this.url + ", httpMethod=" + this.httpMethod + ", returnType=" + this.returnType + ", bodyObject=" + this.bodyObject + ", contentType=" + this.contentType + ", headers=" + this.headers + ", requestInterceptor=" + this.requestInterceptor + ")";
        }
    }
}

