/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.support;

import io.github.sashirestela.cleverclient.support.Configurator;
import java.util.List;
import java.util.Set;

public class CleverClientSSE {
    public static final String EVENT_HEADER = "event: ";
    private static final String DATA_HEADER = "data: ";
    private static final String SEPARATOR = "";
    private LineRecord lineRecord;
    private List<String> endsOfStream;
    private Set<String> eventsWithHeader;

    public CleverClientSSE(LineRecord lineRecord) {
        this.lineRecord = lineRecord;
        this.endsOfStream = Configurator.one().getEndsOfStream();
        this.eventsWithHeader = Set.of(SEPARATOR);
    }

    public CleverClientSSE(LineRecord lineRecord, Set<String> eventsWithHeader) {
        this.lineRecord = lineRecord;
        this.endsOfStream = Configurator.one().getEndsOfStream();
        this.eventsWithHeader = eventsWithHeader;
    }

    public boolean isActualData() {
        return this.eventsWithHeader.contains(this.lineRecord.previous()) && this.lineRecord.current().startsWith(DATA_HEADER) && this.endsOfStream.stream().anyMatch(eos -> !this.lineRecord.current().contains((CharSequence)eos));
    }

    public String getActualData() {
        return this.lineRecord.current().replace(DATA_HEADER, SEPARATOR).strip();
    }

    public String getMatchedEvent() {
        return this.eventsWithHeader.contains(this.lineRecord.previous()) ? this.lineRecord.previous() : null;
    }

    public static class LineRecord {
        private String currentLine;
        private String previousLine;

        public LineRecord(String previousLine, String currentLine) {
            this.previousLine = previousLine;
            this.currentLine = currentLine;
        }

        public LineRecord() {
            this(CleverClientSSE.SEPARATOR, CleverClientSSE.SEPARATOR);
        }

        public void updateWith(String line) {
            this.previousLine = this.currentLine;
            this.currentLine = line;
        }

        public String current() {
            return this.currentLine;
        }

        public String previous() {
            return this.previousLine;
        }
    }
}

