/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient;

import io.github.sashirestela.cleverclient.http.HttpProcessor;
import io.github.sashirestela.cleverclient.http.HttpRequestData;
import io.github.sashirestela.cleverclient.support.Configurator;
import io.github.sashirestela.cleverclient.util.CommonUtil;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleverClient {
    private static final Logger logger = LoggerFactory.getLogger(CleverClient.class);
    private final String baseUrl;
    private final Map<String, String> headers;
    private final HttpClient httpClient;
    private final UnaryOperator<HttpRequestData> requestInterceptor;
    private final HttpProcessor httpProcessor;

    public CleverClient(@NonNull String baseUrl, Map<String, String> headers, HttpClient httpClient, UnaryOperator<HttpRequestData> requestInterceptor, List<String> eventsToRead, List<String> endsOfStream) {
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        this.baseUrl = baseUrl;
        this.headers = Optional.ofNullable(headers).orElse(Map.of());
        this.httpClient = Optional.ofNullable(httpClient).orElse(HttpClient.newHttpClient());
        this.requestInterceptor = requestInterceptor;
        this.httpProcessor = HttpProcessor.builder().baseUrl(this.baseUrl).headers(CommonUtil.mapToListOfString(this.headers)).httpClient(this.httpClient).requestInterceptor(this.requestInterceptor).build();
        Configurator.builder().eventsToRead((Collection<? extends String>)Optional.ofNullable(eventsToRead).orElse(Arrays.asList(new String[0]))).endsOfStream((Collection<? extends String>)Optional.ofNullable(endsOfStream).orElse(Arrays.asList(new String[0]))).build();
        logger.debug("CleverClient has been created.");
    }

    public <T> T create(Class<T> interfaceClass) {
        return this.httpProcessor.createProxy(interfaceClass);
    }

    public static CleverClientBuilder builder() {
        return new CleverClientBuilder();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public UnaryOperator<HttpRequestData> getRequestInterceptor() {
        return this.requestInterceptor;
    }

    public HttpProcessor getHttpProcessor() {
        return this.httpProcessor;
    }

    public static class CleverClientBuilder {
        private String baseUrl;
        private ArrayList<String> headers$key;
        private ArrayList<String> headers$value;
        private HttpClient httpClient;
        private UnaryOperator<HttpRequestData> requestInterceptor;
        private ArrayList<String> eventsToRead;
        private ArrayList<String> endsOfStream;

        CleverClientBuilder() {
        }

        public CleverClientBuilder baseUrl(@NonNull String baseUrl) {
            if (baseUrl == null) {
                throw new NullPointerException("baseUrl is marked non-null but is null");
            }
            this.baseUrl = baseUrl;
            return this;
        }

        public CleverClientBuilder header(String headerKey, String headerValue) {
            if (this.headers$key == null) {
                this.headers$key = new ArrayList();
                this.headers$value = new ArrayList();
            }
            this.headers$key.add(headerKey);
            this.headers$value.add(headerValue);
            return this;
        }

        public CleverClientBuilder headers(Map<? extends String, ? extends String> headers) {
            if (headers == null) {
                throw new NullPointerException("headers cannot be null");
            }
            if (this.headers$key == null) {
                this.headers$key = new ArrayList();
                this.headers$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : headers.entrySet()) {
                this.headers$key.add($lombokEntry.getKey());
                this.headers$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CleverClientBuilder clearHeaders() {
            if (this.headers$key != null) {
                this.headers$key.clear();
                this.headers$value.clear();
            }
            return this;
        }

        public CleverClientBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public CleverClientBuilder requestInterceptor(UnaryOperator<HttpRequestData> requestInterceptor) {
            this.requestInterceptor = requestInterceptor;
            return this;
        }

        public CleverClientBuilder eventToRead(String eventToRead) {
            if (this.eventsToRead == null) {
                this.eventsToRead = new ArrayList();
            }
            this.eventsToRead.add(eventToRead);
            return this;
        }

        public CleverClientBuilder eventsToRead(Collection<? extends String> eventsToRead) {
            if (eventsToRead == null) {
                throw new NullPointerException("eventsToRead cannot be null");
            }
            if (this.eventsToRead == null) {
                this.eventsToRead = new ArrayList();
            }
            this.eventsToRead.addAll(eventsToRead);
            return this;
        }

        public CleverClientBuilder clearEventsToRead() {
            if (this.eventsToRead != null) {
                this.eventsToRead.clear();
            }
            return this;
        }

        public CleverClientBuilder endOfStream(String endOfStream) {
            if (this.endsOfStream == null) {
                this.endsOfStream = new ArrayList();
            }
            this.endsOfStream.add(endOfStream);
            return this;
        }

        public CleverClientBuilder endsOfStream(Collection<? extends String> endsOfStream) {
            if (endsOfStream == null) {
                throw new NullPointerException("endsOfStream cannot be null");
            }
            if (this.endsOfStream == null) {
                this.endsOfStream = new ArrayList();
            }
            this.endsOfStream.addAll(endsOfStream);
            return this;
        }

        public CleverClientBuilder clearEndsOfStream() {
            if (this.endsOfStream != null) {
                this.endsOfStream.clear();
            }
            return this;
        }

        public CleverClient build() {
            List<String> endsOfStream;
            List<String> eventsToRead;
            Map<Object, Object> headers;
            switch (this.headers$key == null ? 0 : this.headers$key.size()) {
                case 0: {
                    headers = Collections.emptyMap();
                    break;
                }
                case 1: {
                    headers = Collections.singletonMap(this.headers$key.get(0), this.headers$value.get(0));
                    break;
                }
                default: {
                    headers = new LinkedHashMap(this.headers$key.size() < 0x40000000 ? 1 + this.headers$key.size() + (this.headers$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.headers$key.size(); ++$i) {
                        headers.put(this.headers$key.get($i), this.headers$value.get($i));
                    }
                    headers = Collections.unmodifiableMap(headers);
                }
            }
            switch (this.eventsToRead == null ? 0 : this.eventsToRead.size()) {
                case 0: {
                    eventsToRead = Collections.emptyList();
                    break;
                }
                case 1: {
                    eventsToRead = Collections.singletonList(this.eventsToRead.get(0));
                    break;
                }
                default: {
                    eventsToRead = Collections.unmodifiableList(new ArrayList<String>(this.eventsToRead));
                }
            }
            switch (this.endsOfStream == null ? 0 : this.endsOfStream.size()) {
                case 0: {
                    endsOfStream = Collections.emptyList();
                    break;
                }
                case 1: {
                    endsOfStream = Collections.singletonList(this.endsOfStream.get(0));
                    break;
                }
                default: {
                    endsOfStream = Collections.unmodifiableList(new ArrayList<String>(this.endsOfStream));
                }
            }
            return new CleverClient(this.baseUrl, headers, this.httpClient, this.requestInterceptor, eventsToRead, endsOfStream);
        }

        public String toString() {
            return "CleverClient.CleverClientBuilder(baseUrl=" + this.baseUrl + ", headers$key=" + this.headers$key + ", headers$value=" + this.headers$value + ", httpClient=" + this.httpClient + ", requestInterceptor=" + this.requestInterceptor + ", eventsToRead=" + this.eventsToRead + ", endsOfStream=" + this.endsOfStream + ")";
        }
    }
}

