/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class UnixTimestampDeserializer
extends JsonDeserializer<ZonedDateTime> {
    public ZonedDateTime deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        long timestamp = jp.getLongValue();
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(timestamp), ZoneId.systemDefault());
    }
}

