/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.metadata;

import io.github.sashirestela.cleverclient.support.ReturnType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class InterfaceMetadata {
    private static final String ANNOT_RESOURCE = "Resource";
    private static final String ANNOT_HEADER = "Header";
    private static final String ANNOT_MULTIPART = "Multipart";
    private static final String ANNOT_PARAM_BODY = "Body";
    private static final String ANNOT_PARAM_PATH = "Path";
    private static final String ANNOT_PARAM_QUERY = "Query";
    private static final String ANNOT_FIELD_NAME = "name";
    private static final String ANNOT_FIELD_VALUE = "value";
    private final String name;
    private final List<AnnotationMetadata> annotations;
    private final Map<String, MethodMetadata> methodBySignature;

    public String getFullUrlByMethod(MethodMetadata methodMetadata) {
        Optional<AnnotationMetadata> resourceAnnot = this.annotations.stream().filter(annot -> annot.getName().equals(ANNOT_RESOURCE)).findFirst();
        String resourceUrl = resourceAnnot.isPresent() ? resourceAnnot.get().getValue() : "";
        Optional<AnnotationMetadata> httpMethodAnnot = methodMetadata.getAnnotations().stream().filter(AnnotationMetadata::isHttpMethod).findFirst();
        String httpMethodUrl = httpMethodAnnot.isPresent() ? httpMethodAnnot.get().getValue() : "";
        return resourceUrl + httpMethodUrl;
    }

    public List<String> getFullHeadersByMethod(MethodMetadata methodMetadata) {
        List fullHeaderAnnots = this.annotations.stream().filter(annot -> annot.getName().equals(ANNOT_HEADER)).collect(Collectors.toList());
        List methodHeaderAnnots = methodMetadata.getAnnotations().stream().filter(annot -> annot.getName().equals(ANNOT_HEADER)).collect(Collectors.toList());
        fullHeaderAnnots.addAll(methodHeaderAnnots);
        ArrayList<String> fullHeaders = new ArrayList<String>();
        for (AnnotationMetadata annot2 : fullHeaderAnnots) {
            fullHeaders.add(annot2.getValueByField().get(ANNOT_FIELD_NAME));
            fullHeaders.add(annot2.getValueByField().get(ANNOT_FIELD_VALUE));
        }
        return fullHeaders;
    }

    InterfaceMetadata(String name, List<AnnotationMetadata> annotations, Map<String, MethodMetadata> methodBySignature) {
        this.name = name;
        this.annotations = annotations;
        this.methodBySignature = methodBySignature;
    }

    public static InterfaceMetadataBuilder builder() {
        return new InterfaceMetadataBuilder();
    }

    public String getName() {
        return this.name;
    }

    public List<AnnotationMetadata> getAnnotations() {
        return this.annotations;
    }

    public Map<String, MethodMetadata> getMethodBySignature() {
        return this.methodBySignature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InterfaceMetadata)) {
            return false;
        }
        InterfaceMetadata other = (InterfaceMetadata)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<AnnotationMetadata> this$annotations = this.getAnnotations();
        List<AnnotationMetadata> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        Map<String, MethodMetadata> this$methodBySignature = this.getMethodBySignature();
        Map<String, MethodMetadata> other$methodBySignature = other.getMethodBySignature();
        return !(this$methodBySignature == null ? other$methodBySignature != null : !((Object)this$methodBySignature).equals(other$methodBySignature));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<AnnotationMetadata> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        Map<String, MethodMetadata> $methodBySignature = this.getMethodBySignature();
        result = result * 59 + ($methodBySignature == null ? 43 : ((Object)$methodBySignature).hashCode());
        return result;
    }

    public String toString() {
        return "InterfaceMetadata(name=" + this.getName() + ", annotations=" + this.getAnnotations() + ", methodBySignature=" + this.getMethodBySignature() + ")";
    }

    public static class InterfaceMetadataBuilder {
        private String name;
        private List<AnnotationMetadata> annotations;
        private Map<String, MethodMetadata> methodBySignature;

        InterfaceMetadataBuilder() {
        }

        public InterfaceMetadataBuilder name(String name) {
            this.name = name;
            return this;
        }

        public InterfaceMetadataBuilder annotations(List<AnnotationMetadata> annotations) {
            this.annotations = annotations;
            return this;
        }

        public InterfaceMetadataBuilder methodBySignature(Map<String, MethodMetadata> methodBySignature) {
            this.methodBySignature = methodBySignature;
            return this;
        }

        public InterfaceMetadata build() {
            return new InterfaceMetadata(this.name, this.annotations, this.methodBySignature);
        }

        public String toString() {
            return "InterfaceMetadata.InterfaceMetadataBuilder(name=" + this.name + ", annotations=" + this.annotations + ", methodBySignature=" + this.methodBySignature + ")";
        }
    }

    public static final class AnnotationMetadata {
        private final String name;
        private final boolean isHttpMethod;
        private final Map<String, String> valueByField;

        public String getValue() {
            return this.valueByField.get(InterfaceMetadata.ANNOT_FIELD_VALUE);
        }

        AnnotationMetadata(String name, boolean isHttpMethod, Map<String, String> valueByField) {
            this.name = name;
            this.isHttpMethod = isHttpMethod;
            this.valueByField = valueByField;
        }

        public static AnnotationMetadataBuilder builder() {
            return new AnnotationMetadataBuilder();
        }

        public String getName() {
            return this.name;
        }

        public boolean isHttpMethod() {
            return this.isHttpMethod;
        }

        public Map<String, String> getValueByField() {
            return this.valueByField;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnnotationMetadata)) {
                return false;
            }
            AnnotationMetadata other = (AnnotationMetadata)o;
            if (this.isHttpMethod() != other.isHttpMethod()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Map<String, String> this$valueByField = this.getValueByField();
            Map<String, String> other$valueByField = other.getValueByField();
            return !(this$valueByField == null ? other$valueByField != null : !((Object)this$valueByField).equals(other$valueByField));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isHttpMethod() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Map<String, String> $valueByField = this.getValueByField();
            result = result * 59 + ($valueByField == null ? 43 : ((Object)$valueByField).hashCode());
            return result;
        }

        public String toString() {
            return "InterfaceMetadata.AnnotationMetadata(name=" + this.getName() + ", isHttpMethod=" + this.isHttpMethod() + ", valueByField=" + this.getValueByField() + ")";
        }

        public static class AnnotationMetadataBuilder {
            private String name;
            private boolean isHttpMethod;
            private Map<String, String> valueByField;

            AnnotationMetadataBuilder() {
            }

            public AnnotationMetadataBuilder name(String name) {
                this.name = name;
                return this;
            }

            public AnnotationMetadataBuilder isHttpMethod(boolean isHttpMethod) {
                this.isHttpMethod = isHttpMethod;
                return this;
            }

            public AnnotationMetadataBuilder valueByField(Map<String, String> valueByField) {
                this.valueByField = valueByField;
                return this;
            }

            public AnnotationMetadata build() {
                return new AnnotationMetadata(this.name, this.isHttpMethod, this.valueByField);
            }

            public String toString() {
                return "InterfaceMetadata.AnnotationMetadata.AnnotationMetadataBuilder(name=" + this.name + ", isHttpMethod=" + this.isHttpMethod + ", valueByField=" + this.valueByField + ")";
            }
        }
    }

    public static final class ParameterMetadata {
        private final int index;
        private final AnnotationMetadata annotation;

        ParameterMetadata(int index, AnnotationMetadata annotation) {
            this.index = index;
            this.annotation = annotation;
        }

        public static ParameterMetadataBuilder builder() {
            return new ParameterMetadataBuilder();
        }

        public int getIndex() {
            return this.index;
        }

        public AnnotationMetadata getAnnotation() {
            return this.annotation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParameterMetadata)) {
                return false;
            }
            ParameterMetadata other = (ParameterMetadata)o;
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            AnnotationMetadata this$annotation = this.getAnnotation();
            AnnotationMetadata other$annotation = other.getAnnotation();
            return !(this$annotation == null ? other$annotation != null : !((Object)this$annotation).equals(other$annotation));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            AnnotationMetadata $annotation = this.getAnnotation();
            result = result * 59 + ($annotation == null ? 43 : ((Object)$annotation).hashCode());
            return result;
        }

        public String toString() {
            return "InterfaceMetadata.ParameterMetadata(index=" + this.getIndex() + ", annotation=" + this.getAnnotation() + ")";
        }

        public static class ParameterMetadataBuilder {
            private int index;
            private AnnotationMetadata annotation;

            ParameterMetadataBuilder() {
            }

            public ParameterMetadataBuilder index(int index) {
                this.index = index;
                return this;
            }

            public ParameterMetadataBuilder annotation(AnnotationMetadata annotation) {
                this.annotation = annotation;
                return this;
            }

            public ParameterMetadata build() {
                return new ParameterMetadata(this.index, this.annotation);
            }

            public String toString() {
                return "InterfaceMetadata.ParameterMetadata.ParameterMetadataBuilder(index=" + this.index + ", annotation=" + this.annotation + ")";
            }
        }
    }

    public static final class MethodMetadata {
        private final String name;
        private final ReturnType returnType;
        private final boolean isDefault;
        private final List<AnnotationMetadata> annotations;
        private final List<ParameterMetadata> parameters;

        public boolean hasHttpAnnotation() {
            return this.annotations.stream().anyMatch(AnnotationMetadata::isHttpMethod);
        }

        public String getHttpAnnotationName() {
            return this.annotations.stream().filter(AnnotationMetadata::isHttpMethod).findFirst().get().getName();
        }

        public boolean isMultipart() {
            return this.annotations.stream().anyMatch(annot -> annot.getName().equals(InterfaceMetadata.ANNOT_MULTIPART));
        }

        public int getBodyIndex() {
            Optional<ParameterMetadata> bodyParam = this.parameters.stream().filter(param -> param.getAnnotation().getName().equals(InterfaceMetadata.ANNOT_PARAM_BODY)).findFirst();
            return bodyParam.isPresent() ? bodyParam.get().getIndex() : -1;
        }

        public List<ParameterMetadata> getPathParameters() {
            return this.getParametersFilteredBy(InterfaceMetadata.ANNOT_PARAM_PATH);
        }

        public List<ParameterMetadata> getQueryParameters() {
            return this.getParametersFilteredBy(InterfaceMetadata.ANNOT_PARAM_QUERY);
        }

        private List<ParameterMetadata> getParametersFilteredBy(String annotationName) {
            return this.parameters.stream().filter(param -> param.getAnnotation() != null).filter(param -> param.getAnnotation().getName().equals(annotationName)).collect(Collectors.toList());
        }

        MethodMetadata(String name, ReturnType returnType, boolean isDefault, List<AnnotationMetadata> annotations, List<ParameterMetadata> parameters) {
            this.name = name;
            this.returnType = returnType;
            this.isDefault = isDefault;
            this.annotations = annotations;
            this.parameters = parameters;
        }

        public static MethodMetadataBuilder builder() {
            return new MethodMetadataBuilder();
        }

        public String getName() {
            return this.name;
        }

        public ReturnType getReturnType() {
            return this.returnType;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public List<AnnotationMetadata> getAnnotations() {
            return this.annotations;
        }

        public List<ParameterMetadata> getParameters() {
            return this.parameters;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodMetadata)) {
                return false;
            }
            MethodMetadata other = (MethodMetadata)o;
            if (this.isDefault() != other.isDefault()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            ReturnType this$returnType = this.getReturnType();
            ReturnType other$returnType = other.getReturnType();
            if (this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType)) {
                return false;
            }
            List<AnnotationMetadata> this$annotations = this.getAnnotations();
            List<AnnotationMetadata> other$annotations = other.getAnnotations();
            if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
                return false;
            }
            List<ParameterMetadata> this$parameters = this.getParameters();
            List<ParameterMetadata> other$parameters = other.getParameters();
            return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDefault() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            ReturnType $returnType = this.getReturnType();
            result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
            List<AnnotationMetadata> $annotations = this.getAnnotations();
            result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
            List<ParameterMetadata> $parameters = this.getParameters();
            result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
            return result;
        }

        public String toString() {
            return "InterfaceMetadata.MethodMetadata(name=" + this.getName() + ", returnType=" + this.getReturnType() + ", isDefault=" + this.isDefault() + ", annotations=" + this.getAnnotations() + ", parameters=" + this.getParameters() + ")";
        }

        public static class MethodMetadataBuilder {
            private String name;
            private ReturnType returnType;
            private boolean isDefault;
            private List<AnnotationMetadata> annotations;
            private List<ParameterMetadata> parameters;

            MethodMetadataBuilder() {
            }

            public MethodMetadataBuilder name(String name) {
                this.name = name;
                return this;
            }

            public MethodMetadataBuilder returnType(ReturnType returnType) {
                this.returnType = returnType;
                return this;
            }

            public MethodMetadataBuilder isDefault(boolean isDefault) {
                this.isDefault = isDefault;
                return this;
            }

            public MethodMetadataBuilder annotations(List<AnnotationMetadata> annotations) {
                this.annotations = annotations;
                return this;
            }

            public MethodMetadataBuilder parameters(List<ParameterMetadata> parameters) {
                this.parameters = parameters;
                return this;
            }

            public MethodMetadata build() {
                return new MethodMetadata(this.name, this.returnType, this.isDefault, this.annotations, this.parameters);
            }

            public String toString() {
                return "InterfaceMetadata.MethodMetadata.MethodMetadataBuilder(name=" + this.name + ", returnType=" + this.returnType + ", isDefault=" + this.isDefault + ", annotations=" + this.annotations + ", parameters=" + this.parameters + ")";
            }
        }
    }
}

