/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.http;

import io.github.sashirestela.cleverclient.http.HttpConnector;
import io.github.sashirestela.cleverclient.http.URLBuilder;
import io.github.sashirestela.cleverclient.metadata.InterfaceMetadata;
import io.github.sashirestela.cleverclient.metadata.InterfaceMetadataStore;
import io.github.sashirestela.cleverclient.support.ReturnType;
import io.github.sashirestela.cleverclient.util.Constant;
import io.github.sashirestela.cleverclient.util.ReflectUtil;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProcessor
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(HttpProcessor.class);
    private final String baseUrl;
    private final List<String> headers;
    private final HttpClient httpClient;
    private final Function<String, String> urlInterceptor;

    public <T> T createProxy(Class<T> interfaceClass) {
        InterfaceMetadataStore.one().save(interfaceClass);
        T proxy = ReflectUtil.createProxy(interfaceClass, this);
        logger.debug("Created Instance : {}", (Object)interfaceClass.getSimpleName());
        return proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        logger.debug("Invoked Method : {}.{}()", (Object)method.getDeclaringClass().getSimpleName(), (Object)method.getName());
        if (method.isDefault()) {
            return MethodHandles.lookup().findSpecial(method.getDeclaringClass(), method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), method.getDeclaringClass()).bindTo(proxy).invokeWithArguments(arguments);
        }
        Object responseObject = this.resolve(method, arguments);
        logger.debug("Received Response");
        return responseObject;
    }

    private Object resolve(Method method, Object[] arguments) {
        InterfaceMetadata interfaceMetadata = InterfaceMetadataStore.one().get(method.getDeclaringClass());
        InterfaceMetadata.MethodMetadata methodMetadata = interfaceMetadata.getMethodBySignature().get(method.toString());
        String urlMethod = interfaceMetadata.getFullUrlByMethod(methodMetadata);
        Object url = this.baseUrl + URLBuilder.one().build(urlMethod, methodMetadata, arguments);
        if (this.urlInterceptor != null) {
            url = this.urlInterceptor.apply((String)url);
        }
        String httpMethod = methodMetadata.getHttpAnnotationName();
        ReturnType returnType = methodMetadata.getReturnType();
        boolean isMultipart = methodMetadata.isMultipart();
        Object bodyObject = this.calculateBodyObject(methodMetadata, arguments);
        ArrayList<String> fullHeaders = new ArrayList<String>(this.headers);
        fullHeaders.addAll(this.calculateHeaderContentType(bodyObject, isMultipart));
        fullHeaders.addAll(interfaceMetadata.getFullHeadersByMethod(methodMetadata));
        String[] fullHeadersArray = fullHeaders.toArray(new String[0]);
        HttpConnector httpConnector = HttpConnector.builder().httpClient(this.httpClient).url((String)url).httpMethod(httpMethod).returnType(returnType).bodyObject(bodyObject).isMultipart(isMultipart).headersArray(fullHeadersArray).build();
        logger.debug("Http Call : {} {}", (Object)httpMethod, url);
        logger.debug("Request Headers : {}", (Object)this.printHeaders(fullHeaders));
        return httpConnector.sendRequest();
    }

    private Object calculateBodyObject(InterfaceMetadata.MethodMetadata methodMetadata, Object[] arguments) {
        int indexBody = methodMetadata.getBodyIndex();
        return indexBody >= 0 ? arguments[indexBody] : null;
    }

    private List<String> calculateHeaderContentType(Object bodyObject, boolean isMultipart) {
        ArrayList<String> headerContentType = new ArrayList<String>();
        if (bodyObject != null) {
            headerContentType.add("Content-Type");
            Object contentType = isMultipart ? "multipart/form-data; boundary=\"" + Constant.BOUNDARY_VALUE + "\"" : "application/json";
            headerContentType.add((String)contentType);
        }
        return headerContentType;
    }

    private String printHeaders(List<String> headers) {
        Object print = "{";
        for (int i = 0; i < headers.size(); ++i) {
            String headerKey;
            if (i > 1) {
                print = (String)print + ", ";
            }
            String headerVal = (headerKey = headers.get(i++)).equals("Authorization") ? "*".repeat(10) : headers.get(i);
            print = (String)print + headerKey + " = " + headerVal;
        }
        print = (String)print + "}";
        return print;
    }

    HttpProcessor(String baseUrl, List<String> headers, HttpClient httpClient, Function<String, String> urlInterceptor) {
        this.baseUrl = baseUrl;
        this.headers = headers;
        this.httpClient = httpClient;
        this.urlInterceptor = urlInterceptor;
    }

    public static HttpProcessorBuilder builder() {
        return new HttpProcessorBuilder();
    }

    public static class HttpProcessorBuilder {
        private String baseUrl;
        private List<String> headers;
        private HttpClient httpClient;
        private Function<String, String> urlInterceptor;

        HttpProcessorBuilder() {
        }

        public HttpProcessorBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public HttpProcessorBuilder headers(List<String> headers) {
            this.headers = headers;
            return this;
        }

        public HttpProcessorBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public HttpProcessorBuilder urlInterceptor(Function<String, String> urlInterceptor) {
            this.urlInterceptor = urlInterceptor;
            return this;
        }

        public HttpProcessor build() {
            return new HttpProcessor(this.baseUrl, this.headers, this.httpClient, this.urlInterceptor);
        }

        public String toString() {
            return "HttpProcessor.HttpProcessorBuilder(baseUrl=" + this.baseUrl + ", headers=" + this.headers + ", httpClient=" + this.httpClient + ", urlInterceptor=" + this.urlInterceptor + ")";
        }
    }
}

