/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient;

import io.github.sashirestela.cleverclient.http.HttpProcessor;
import io.github.sashirestela.cleverclient.http.InvocationFilter;
import java.net.http.HttpClient;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleverClient {
    private static Logger logger = LoggerFactory.getLogger(CleverClient.class);
    @NonNull
    private HttpClient httpClient;
    @NonNull
    private String urlBase;
    private List<String> headers;
    private HttpProcessor httpProcessor;

    public CleverClient(HttpClient httpClient, String urlBase, List<String> headers) {
        this.httpClient = httpClient;
        this.urlBase = urlBase;
        this.headers = headers;
        this.httpProcessor = new HttpProcessor(this.httpClient, this.urlBase, this.headers);
        logger.debug("CleverClient has been created.");
    }

    public <T> T create(Class<T> interfaceClass) {
        return this.httpProcessor.createProxy(interfaceClass, null);
    }

    public <T> T create(Class<T> interfaceClass, InvocationFilter filter) {
        return this.httpProcessor.createProxy(interfaceClass, filter);
    }

    public static CleverClientBuilder builder() {
        return new CleverClientBuilder();
    }

    public CleverClient() {
    }

    public static class CleverClientBuilder {
        private HttpClient httpClient;
        private String urlBase;
        private List<String> headers;

        CleverClientBuilder() {
        }

        public CleverClientBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public CleverClientBuilder urlBase(String urlBase) {
            this.urlBase = urlBase;
            return this;
        }

        public CleverClientBuilder headers(List<String> headers) {
            this.headers = headers;
            return this;
        }

        public CleverClient build() {
            return new CleverClient(this.httpClient, this.urlBase, this.headers);
        }

        public String toString() {
            return "CleverClient.CleverClientBuilder(httpClient=" + this.httpClient + ", urlBase=" + this.urlBase + ", headers=" + this.headers + ")";
        }
    }
}

