/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.metadata;

import io.github.sashirestela.cleverclient.annotation.HttpMethod;
import io.github.sashirestela.cleverclient.metadata.InterfaceMetadata;
import io.github.sashirestela.cleverclient.support.CleverClientException;
import io.github.sashirestela.cleverclient.support.ReturnType;
import io.github.sashirestela.cleverclient.util.CommonUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceMetadataStore {
    private static Logger logger = LoggerFactory.getLogger(InterfaceMetadataStore.class);
    private static InterfaceMetadataStore store = null;
    private Map<String, InterfaceMetadata> interfacesByFullName = new HashMap<String, InterfaceMetadata>();

    private InterfaceMetadataStore() {
    }

    public static InterfaceMetadataStore one() {
        if (store == null) {
            store = new InterfaceMetadataStore();
        }
        return store;
    }

    public void save(Class<?> interfaceClass) {
        if (this.interfacesByFullName.containsKey(interfaceClass.getName())) {
            return;
        }
        HashMap<String, InterfaceMetadata.MethodMetadata> methodBySignature = new HashMap<String, InterfaceMetadata.MethodMetadata>();
        for (Method javaMethod : interfaceClass.getMethods()) {
            InterfaceMetadata.MethodMetadata methodMetadata = InterfaceMetadata.MethodMetadata.builder().name(javaMethod.getName()).returnType(new ReturnType(javaMethod.getGenericReturnType().getTypeName())).isDefault(javaMethod.isDefault()).annotations(this.getAnnotations(javaMethod.getDeclaredAnnotations())).parameters(this.getParameters(javaMethod.getParameters())).build();
            methodBySignature.put(javaMethod.toString(), methodMetadata);
        }
        InterfaceMetadata interfaceMetadata = InterfaceMetadata.builder().name(interfaceClass.getSimpleName()).annotations(this.getAnnotations(interfaceClass.getDeclaredAnnotations())).methodBySignature(methodBySignature).build();
        this.validate(interfaceMetadata);
        this.interfacesByFullName.put(interfaceClass.getName(), interfaceMetadata);
        logger.debug("The interface {} was saved", (Object)interfaceClass.getSimpleName());
    }

    public InterfaceMetadata get(Class<?> interfaceClass) {
        if (this.interfacesByFullName.containsKey(interfaceClass.getName())) {
            return this.interfacesByFullName.get(interfaceClass.getName());
        }
        throw new CleverClientException("The interface {0} has not been saved yet.", interfaceClass.getSimpleName(), null);
    }

    private List<InterfaceMetadata.AnnotationMetadata> getAnnotations(Annotation[] javaAnnotations) {
        ArrayList<InterfaceMetadata.AnnotationMetadata> annotations = new ArrayList<InterfaceMetadata.AnnotationMetadata>();
        boolean isAnnotArray = false;
        for (Annotation javaAnnotation : javaAnnotations) {
            HashMap<String, String> valueByField = new HashMap<String, String>();
            for (Method javaAnnotMethod : javaAnnotation.annotationType().getDeclaredMethods()) {
                Object object;
                try {
                    object = javaAnnotMethod.invoke((Object)javaAnnotation, (Object[])null);
                }
                catch (Exception e) {
                    object = null;
                }
                if (object instanceof Annotation[]) {
                    isAnnotArray = true;
                    annotations.addAll(this.getAnnotations((Annotation[])object));
                    continue;
                }
                isAnnotArray = false;
                String field = javaAnnotMethod.getName();
                String value = object instanceof String ? (String)object : null;
                valueByField.put(field, value);
            }
            if (isAnnotArray) continue;
            InterfaceMetadata.AnnotationMetadata annotationMetadata = InterfaceMetadata.AnnotationMetadata.builder().name(javaAnnotation.annotationType().getSimpleName()).isHttpMethod(javaAnnotation.annotationType().isAnnotationPresent(HttpMethod.class)).valueByField(valueByField).build();
            annotations.add(annotationMetadata);
        }
        return annotations;
    }

    private List<InterfaceMetadata.ParameterMetadata> getParameters(Parameter[] javaParameters) {
        ArrayList<InterfaceMetadata.ParameterMetadata> parameters = new ArrayList<InterfaceMetadata.ParameterMetadata>();
        int index = 0;
        for (Parameter javaParameter : javaParameters) {
            List<InterfaceMetadata.AnnotationMetadata> annotations = this.getAnnotations(javaParameter.getDeclaredAnnotations());
            InterfaceMetadata.ParameterMetadata parameterMetadata = InterfaceMetadata.ParameterMetadata.builder().index(index++).annotation(annotations.size() > 0 ? annotations.get(0) : null).build();
            parameters.add(parameterMetadata);
        }
        return parameters;
    }

    private void validate(InterfaceMetadata interfaceMetadata) {
        interfaceMetadata.getMethodBySignature().forEach((methodSignature, methodMetadata) -> {
            if (!methodMetadata.isDefault() && !methodMetadata.hasHttpAnnotation()) {
                throw new CleverClientException("Missing HTTP annotation for the method {0}.", methodMetadata.getName(), null);
            }
            String url = interfaceMetadata.getFullUrlByMethod((InterfaceMetadata.MethodMetadata)methodMetadata);
            List<String> listPathParams = CommonUtil.findFullMatches(url, "\\{(.*?)\\}");
            if (!CommonUtil.isNullOrEmpty(listPathParams)) {
                listPathParams.forEach(pathParam -> methodMetadata.getPathParameters().stream().map(parameter -> parameter.getAnnotation().getValue()).filter(paramAnnotValue -> pathParam.equals(paramAnnotValue)).findFirst().orElseThrow(() -> new CleverClientException("Path param {0} in the url cannot find an annotated argument in the method {1}.", pathParam, methodMetadata.getName(), null)));
            }
        });
    }
}

