/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.http;

import io.github.sashirestela.cleverclient.http.HttpConnector;
import io.github.sashirestela.cleverclient.http.URLBuilder;
import io.github.sashirestela.cleverclient.metadata.InterfaceMetadata;
import io.github.sashirestela.cleverclient.metadata.InterfaceMetadataStore;
import io.github.sashirestela.cleverclient.support.ReturnType;
import io.github.sashirestela.cleverclient.util.Constant;
import io.github.sashirestela.cleverclient.util.ReflectUtil;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProcessor
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(HttpProcessor.class);
    private final HttpClient httpClient;
    private final String baseUrl;
    private final List<String> headers;

    public HttpProcessor(String baseUrl, List<String> headers, HttpClient httpClient) {
        this.baseUrl = baseUrl;
        this.headers = headers;
        this.httpClient = httpClient;
    }

    public <T> T createProxy(Class<T> interfaceClass) {
        InterfaceMetadataStore.one().save(interfaceClass);
        T proxy = ReflectUtil.createProxy(interfaceClass, this);
        logger.debug("Created Instance : {}", (Object)interfaceClass.getSimpleName());
        return proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        logger.debug("Invoked Method : {}.{}()", (Object)method.getDeclaringClass().getSimpleName(), (Object)method.getName());
        if (method.isDefault()) {
            return MethodHandles.lookup().findSpecial(method.getDeclaringClass(), method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), method.getDeclaringClass()).bindTo(proxy).invokeWithArguments(arguments);
        }
        Object responseObject = this.resolve(method, arguments);
        logger.debug("Received Response");
        return responseObject;
    }

    private Object resolve(Method method, Object[] arguments) {
        InterfaceMetadata interfaceMetadata = InterfaceMetadataStore.one().get(method.getDeclaringClass());
        InterfaceMetadata.MethodMetadata methodMetadata = interfaceMetadata.getMethodBySignature().get(method.toString());
        String urlMethod = interfaceMetadata.getFullUrlByMethod(methodMetadata);
        String url = this.baseUrl + URLBuilder.one().build(urlMethod, methodMetadata, arguments);
        String httpMethod = methodMetadata.getHttpAnnotationName();
        ReturnType returnType = methodMetadata.getReturnType();
        boolean isMultipart = methodMetadata.isMultipart();
        Object bodyObject = this.calculateBodyObject(methodMetadata, arguments);
        ArrayList<String> fullHeaders = new ArrayList<String>(this.headers);
        fullHeaders.addAll(this.calculateHeaderContentType(bodyObject, isMultipart));
        fullHeaders.addAll(interfaceMetadata.getFullHeadersByMethod(methodMetadata));
        String[] fullHeadersArray = fullHeaders.toArray(new String[0]);
        HttpConnector httpConnector = HttpConnector.builder().httpClient(this.httpClient).url(url).httpMethod(httpMethod).returnType(returnType).bodyObject(bodyObject).isMultipart(isMultipart).headersArray(fullHeadersArray).build();
        logger.debug("Http Call : {} {}", (Object)httpMethod, (Object)url);
        logger.debug("Request Headers : {}", (Object)this.printHeaders(fullHeaders));
        return httpConnector.sendRequest();
    }

    private Object calculateBodyObject(InterfaceMetadata.MethodMetadata methodMetadata, Object[] arguments) {
        int indexBody = methodMetadata.getBodyIndex();
        return indexBody >= 0 ? arguments[indexBody] : null;
    }

    private List<String> calculateHeaderContentType(Object bodyObject, boolean isMultipart) {
        ArrayList<String> headerContentType = new ArrayList<String>();
        if (bodyObject != null) {
            headerContentType.add("Content-Type");
            Object contentType = isMultipart ? "multipart/form-data; boundary=\"" + Constant.BOUNDARY_VALUE + "\"" : "application/json";
            headerContentType.add((String)contentType);
        }
        return headerContentType;
    }

    private String printHeaders(List<String> headers) {
        Object print = "{";
        for (int i = 0; i < headers.size(); ++i) {
            String headerKey;
            if (i > 1) {
                print = (String)print + ", ";
            }
            String headerVal = (headerKey = headers.get(i++)).equals("Authorization") ? "*".repeat(10) : headers.get(i);
            print = (String)print + headerKey + " = " + headerVal;
        }
        print = (String)print + "}";
        return print;
    }
}

