/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.http;

import java.lang.reflect.Method;

public class ReturnType {
    private static final String ASYNC = "java.util.concurrent.CompletableFuture";
    private static final String STREAM = "java.util.stream.Stream";
    private static final String LIST = "java.util.List";
    private static final String INPUTSTREAM = "java.io.InputStream";
    private static final String STRING = "java.lang.String";
    private static final String REGEX = "[<>]";
    private static final String JAVA_PCK = "java";
    private String fullClassName;
    private String[] returnTypeArray;
    private int size;
    private int firstIndex;
    private int lastIndex;
    private int prevLastIndex;

    public ReturnType(String fullClassName) {
        this.fullClassName = fullClassName;
        this.returnTypeArray = fullClassName.split(REGEX, 0);
        this.size = this.returnTypeArray.length;
        this.firstIndex = 0;
        this.lastIndex = this.size - 1;
        this.prevLastIndex = this.lastIndex - 1;
    }

    public ReturnType(Method method) {
        this(method.getGenericReturnType().getTypeName());
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public Class<?> getBaseClass() {
        return this.getClass(this.lastIndex);
    }

    public Class<?> getGenericClass() {
        return this.getClass(this.prevLastIndex);
    }

    private Class<?> getClass(int index) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.returnTypeArray[index]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    public Category category() {
        if (this.isAsync()) {
            return this.asyncCategory();
        }
        return this.syncCategory();
    }

    private Category asyncCategory() {
        if (this.isStream()) {
            return Category.ASYNC_STREAM;
        }
        if (this.isList()) {
            return Category.ASYNC_LIST;
        }
        if (this.isGeneric()) {
            return Category.ASYNC_GENERIC;
        }
        if (this.isObject()) {
            return Category.ASYNC_OBJECT;
        }
        if (this.isBinary()) {
            return Category.ASYNC_BINARY;
        }
        if (this.isPlainText()) {
            return Category.ASYNC_PLAIN_TEXT;
        }
        return null;
    }

    private Category syncCategory() {
        if (this.isStream()) {
            return Category.SYNC_STREAM;
        }
        if (this.isList()) {
            return Category.SYNC_LIST;
        }
        if (this.isGeneric()) {
            return Category.SYNC_GENERIC;
        }
        if (this.isObject()) {
            return Category.SYNC_OBJECT;
        }
        if (this.isBinary()) {
            return Category.SYNC_BINARY;
        }
        if (this.isPlainText()) {
            return Category.SYNC_PLAIN_TEXT;
        }
        return null;
    }

    public boolean isAsync() {
        return this.size > 1 && ASYNC.equals(this.returnTypeArray[this.firstIndex]);
    }

    public boolean isStream() {
        return this.size > 1 && STREAM.equals(this.returnTypeArray[this.prevLastIndex]);
    }

    public boolean isList() {
        return this.size > 1 && LIST.equals(this.returnTypeArray[this.prevLastIndex]);
    }

    public boolean isGeneric() {
        return (this.isAsync() && this.size > 2 || !this.isAsync() && this.size > 1) && !this.returnTypeArray[this.prevLastIndex].startsWith(JAVA_PCK);
    }

    public boolean isObject() {
        return !this.isInputStream() && !this.isString() && (this.size == 1 || this.size == 2 && this.isAsync());
    }

    public boolean isBinary() {
        return this.isInputStream() && (this.size == 1 || this.size == 2 && this.isAsync());
    }

    public boolean isPlainText() {
        return this.isString() && (this.size == 1 || this.size == 2 && this.isAsync());
    }

    private boolean isInputStream() {
        return INPUTSTREAM.equals(this.returnTypeArray[this.lastIndex]);
    }

    private boolean isString() {
        return STRING.equals(this.returnTypeArray[this.lastIndex]);
    }

    public static enum Category {
        ASYNC_STREAM,
        ASYNC_LIST,
        ASYNC_GENERIC,
        ASYNC_OBJECT,
        ASYNC_BINARY,
        ASYNC_PLAIN_TEXT,
        SYNC_STREAM,
        SYNC_LIST,
        SYNC_GENERIC,
        SYNC_OBJECT,
        SYNC_BINARY,
        SYNC_PLAIN_TEXT;

    }
}

