/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.sender;

import io.github.sashirestela.cleverclient.ReturnType;
import io.github.sashirestela.cleverclient.sender.HttpAsyncListSender;
import io.github.sashirestela.cleverclient.sender.HttpAsyncObjectSender;
import io.github.sashirestela.cleverclient.sender.HttpAsyncPlainTextSender;
import io.github.sashirestela.cleverclient.sender.HttpAsyncStreamSender;
import io.github.sashirestela.cleverclient.sender.HttpSender;
import io.github.sashirestela.cleverclient.support.CleverClientException;
import java.util.EnumMap;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSenderFactory {
    private static Logger logger = LoggerFactory.getLogger(HttpSenderFactory.class);
    private static HttpSenderFactory factory = null;
    private EnumMap<ReturnType.Category, Supplier<HttpSender>> sendersMap = new EnumMap(ReturnType.Category.class);

    private HttpSenderFactory() {
        this.sendersMap.put(ReturnType.Category.ASYNC_STREAM, HttpAsyncStreamSender::new);
        this.sendersMap.put(ReturnType.Category.ASYNC_LIST, HttpAsyncListSender::new);
        this.sendersMap.put(ReturnType.Category.ASYNC_OBJECT, HttpAsyncObjectSender::new);
        this.sendersMap.put(ReturnType.Category.ASYNC_PLAIN_TEXT, HttpAsyncPlainTextSender::new);
    }

    public static HttpSenderFactory get() {
        if (factory == null) {
            factory = new HttpSenderFactory();
        }
        return factory;
    }

    public HttpSender createSender(ReturnType returnType) {
        HttpSender sender = null;
        ReturnType.Category category = returnType.category();
        if (category == null || !this.sendersMap.containsKey((Object)category)) {
            throw new CleverClientException("Unsupported return type {0}.", returnType.getFullClassName(), null);
        }
        sender = this.sendersMap.get((Object)category).get();
        logger.debug("Created Sender : {}", (Object)sender.getClass().getSimpleName());
        return sender;
    }
}

