/*
 * Decompiled with CFR 0.152.
 */
package io.github.sangkeon.opa.wasm;

import io.github.sangkeon.opa.wasm.Bundle;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class BundleUtil {
    public static Bundle extractBundle(String filename) throws IOException {
        Bundle bundle = new Bundle();
        try (InputStream fi = Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);
             BufferedInputStream bi = new BufferedInputStream(fi);
             GzipCompressorInputStream gzi = new GzipCompressorInputStream((InputStream)bi);
             TarArchiveInputStream i = new TarArchiveInputStream((InputStream)gzi);){
            ArchiveEntry entry = null;
            while ((entry = i.getNextEntry()) != null) {
                if (!i.canReadEntryData(entry)) continue;
                if ("/policy.wasm".equals(entry.getName())) {
                    bundle.setPolicy(IOUtils.toByteArray((InputStream)i));
                    continue;
                }
                if (!"/data.json".equals(entry.getName())) continue;
                bundle.setData(new String(IOUtils.toByteArray((InputStream)i)));
            }
        }
        return bundle;
    }
}

