/*
 * Decompiled with CFR 0.152.
 */
package io.github.sangkeon.opa.wasm;

import io.github.kawamuray.wasmtime.Disposable;
import io.github.kawamuray.wasmtime.Extern;
import io.github.kawamuray.wasmtime.Func;
import io.github.kawamuray.wasmtime.Global;
import io.github.kawamuray.wasmtime.Linker;
import io.github.kawamuray.wasmtime.Store;
import io.github.kawamuray.wasmtime.WasmFunctions;
import io.github.kawamuray.wasmtime.WasmValType;
import io.github.sangkeon.opa.wasm.OPAAddr;
import io.github.sangkeon.opa.wasm.OPAErrorCode;
import io.github.sangkeon.opa.wasm.OPAExportsAPI;
import java.util.Optional;

public class OPAExports
implements OPAExportsAPI,
Disposable {
    private Linker linker;
    private Store<Void> store;
    private Func opaMallocFn = null;
    private Func opaHeapPtrGetFn = null;
    private Func opaHeapPtrSetFn = null;
    private Func opaJsonDumpFn = null;
    private Func opaJsonParseFn = null;
    private Func opaEvalCtxNewFn = null;
    private Func opaEvalCtxSetInputFn = null;
    private Func opaEvalCtxSetDataFn = null;
    private Func opaEvalCtxGetResultFn = null;
    private Func builtinsFn = null;
    private Func evalFn = null;
    private Func entrypointsFn = null;
    private Func opaEvalCtxSetEntryPointFn = null;
    private Func opaFreeFn = null;
    private Func opaValueParseFn = null;
    private Func opaValueDumpFn = null;
    private Func opaValueAddPathFn = null;
    private Func opaValueRemovePathFn = null;
    private Func opaEvalFn = null;
    private Integer abiMajorVersion = null;
    private Integer abiMinorVersion = null;

    private OPAExports(Linker linker, String moduleName, Store<Void> store) {
        this.linker = linker;
        this.store = store;
        this.initFns(moduleName);
    }

    public static OPAExportsAPI getOPAExports(Linker linker, String moduleName, Store<Void> store) {
        return new OPAExports(linker, moduleName, store);
    }

    public void initFns(String moduleName) {
        this.opaMallocFn = ((Extern)this.linker.get(this.store, moduleName, "opa_malloc").get()).func();
        this.opaHeapPtrGetFn = ((Extern)this.linker.get(this.store, moduleName, "opa_heap_ptr_get").get()).func();
        this.opaHeapPtrSetFn = ((Extern)this.linker.get(this.store, moduleName, "opa_heap_ptr_set").get()).func();
        this.opaJsonDumpFn = ((Extern)this.linker.get(this.store, moduleName, "opa_json_dump").get()).func();
        this.opaJsonParseFn = ((Extern)this.linker.get(this.store, moduleName, "opa_json_parse").get()).func();
        this.opaEvalCtxNewFn = ((Extern)this.linker.get(this.store, moduleName, "opa_eval_ctx_new").get()).func();
        this.opaEvalCtxSetInputFn = ((Extern)this.linker.get(this.store, moduleName, "opa_eval_ctx_set_input").get()).func();
        this.opaEvalCtxSetDataFn = ((Extern)this.linker.get(this.store, moduleName, "opa_eval_ctx_set_data").get()).func();
        this.opaEvalCtxGetResultFn = ((Extern)this.linker.get(this.store, moduleName, "opa_eval_ctx_get_result").get()).func();
        this.builtinsFn = ((Extern)this.linker.get(this.store, moduleName, "builtins").get()).func();
        this.evalFn = ((Extern)this.linker.get(this.store, moduleName, "eval").get()).func();
        this.entrypointsFn = ((Extern)this.linker.get(this.store, moduleName, "entrypoints").get()).func();
        this.opaEvalCtxSetEntryPointFn = ((Extern)this.linker.get(this.store, moduleName, "opa_eval_ctx_set_entrypoint").get()).func();
        this.opaFreeFn = ((Extern)this.linker.get(this.store, moduleName, "opa_free").get()).func();
        this.opaValueParseFn = ((Extern)this.linker.get(this.store, moduleName, "opa_value_parse").get()).func();
        this.opaValueDumpFn = ((Extern)this.linker.get(this.store, moduleName, "opa_value_dump").get()).func();
        this.opaValueAddPathFn = ((Extern)this.linker.get(this.store, moduleName, "opa_value_add_path").get()).func();
        this.opaValueRemovePathFn = ((Extern)this.linker.get(this.store, moduleName, "opa_value_remove_path").get()).func();
        Optional opaEvalExtern = this.linker.get(this.store, moduleName, "opa_eval");
        if (opaEvalExtern.isPresent()) {
            this.opaEvalFn = ((Extern)opaEvalExtern.get()).func();
        }
        if (this.linker.get(this.store, moduleName, "opa_wasm_abi_version").isPresent()) {
            Global majorVersion = ((Extern)this.linker.get(this.store, moduleName, "opa_wasm_abi_version").get()).global();
            this.abiMajorVersion = majorVersion.get(this.store).i32();
            majorVersion.dispose();
        }
        if (this.linker.get(this.store, moduleName, "opa_wasm_abi_minor_version").isPresent()) {
            Global minorVersion = ((Extern)this.linker.get(this.store, moduleName, "opa_wasm_abi_minor_version").get()).global();
            this.abiMinorVersion = minorVersion.get(this.store).i32();
            minorVersion.dispose();
        }
    }

    public void disposeFns() {
        if (this.opaMallocFn != null) {
            this.opaMallocFn.dispose();
            this.opaMallocFn = null;
        }
        if (this.opaHeapPtrGetFn != null) {
            this.opaHeapPtrGetFn.dispose();
            this.opaHeapPtrGetFn = null;
        }
        if (this.opaHeapPtrSetFn != null) {
            this.opaHeapPtrSetFn.dispose();
            this.opaHeapPtrSetFn = null;
        }
        if (this.opaJsonDumpFn != null) {
            this.opaJsonDumpFn.dispose();
            this.opaJsonDumpFn = null;
        }
        if (this.opaJsonParseFn != null) {
            this.opaJsonParseFn.dispose();
            this.opaJsonParseFn = null;
        }
        if (this.opaEvalCtxNewFn != null) {
            this.opaEvalCtxNewFn.dispose();
            this.opaEvalCtxNewFn = null;
        }
        if (this.opaEvalCtxSetInputFn != null) {
            this.opaEvalCtxSetInputFn.dispose();
            this.opaEvalCtxSetInputFn = null;
        }
        if (this.opaEvalCtxSetDataFn != null) {
            this.opaEvalCtxSetDataFn.dispose();
            this.opaEvalCtxSetDataFn = null;
        }
        if (this.opaEvalCtxGetResultFn != null) {
            this.opaEvalCtxGetResultFn.dispose();
            this.opaEvalCtxGetResultFn = null;
        }
        if (this.builtinsFn != null) {
            this.builtinsFn.dispose();
            this.builtinsFn = null;
        }
        if (this.evalFn != null) {
            this.evalFn.dispose();
            this.evalFn = null;
        }
        if (this.entrypointsFn != null) {
            this.entrypointsFn.dispose();
            this.entrypointsFn = null;
        }
        if (this.opaEvalCtxSetEntryPointFn != null) {
            this.opaEvalCtxSetEntryPointFn.dispose();
            this.opaEvalCtxSetEntryPointFn = null;
        }
        if (this.opaFreeFn != null) {
            this.opaFreeFn.dispose();
            this.opaFreeFn = null;
        }
        if (this.opaValueParseFn != null) {
            this.opaValueParseFn.dispose();
            this.opaValueParseFn = null;
        }
        if (this.opaValueDumpFn != null) {
            this.opaValueDumpFn.dispose();
            this.opaValueDumpFn = null;
        }
        if (this.opaValueAddPathFn != null) {
            this.opaValueAddPathFn.dispose();
            this.opaValueAddPathFn = null;
        }
        if (this.opaValueRemovePathFn != null) {
            this.opaValueRemovePathFn.dispose();
            this.opaValueRemovePathFn = null;
        }
        if (this.opaEvalFn != null) {
            this.opaEvalFn.dispose();
            this.opaEvalFn = null;
        }
    }

    public void dispose() {
        this.disposeFns();
    }

    @Override
    public OPAAddr opaMalloc(int bytes) {
        WasmFunctions.Function1 opa_malloc = WasmFunctions.func(this.store, (Func)this.opaMallocFn, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        int addr = (Integer)opa_malloc.call((Object)bytes);
        return OPAAddr.newAddr(addr);
    }

    @Override
    public OPAAddr opaHeapPtrGet() {
        WasmFunctions.Function0 opa_heap_ptr_get = WasmFunctions.func(this.store, (Func)this.opaHeapPtrGetFn, (WasmValType)WasmValType.I32);
        int addr = (Integer)opa_heap_ptr_get.call();
        return OPAAddr.newAddr(addr);
    }

    @Override
    public void opaHeapPtrSet(OPAAddr addr) {
        WasmFunctions.Consumer1 opa_heap_ptr_set = WasmFunctions.consumer(this.store, (Func)this.opaHeapPtrSetFn, (WasmValType)WasmValType.I32);
        opa_heap_ptr_set.accept((Object)addr.getInternal());
    }

    @Override
    public OPAAddr opaJsonDump(OPAAddr valueAddr) {
        WasmFunctions.Function1 opa_json_dump = WasmFunctions.func(this.store, (Func)this.opaJsonDumpFn, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        int strAddr = (Integer)opa_json_dump.call((Object)valueAddr.getInternal());
        return OPAAddr.newAddr(strAddr);
    }

    @Override
    public OPAAddr opaJsonParse(OPAAddr addr, int jsonLength) {
        WasmFunctions.Function2 opa_json_parse = WasmFunctions.func(this.store, (Func)this.opaJsonParseFn, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        int valueAddr = (Integer)opa_json_parse.call((Object)addr.getInternal(), (Object)jsonLength);
        return OPAAddr.newAddr(valueAddr);
    }

    @Override
    public OPAAddr opaEvalCtxNew() {
        WasmFunctions.Function0 opa_eval_ctx_new = WasmFunctions.func(this.store, (Func)this.opaEvalCtxNewFn, (WasmValType)WasmValType.I32);
        int ctxAddr = (Integer)opa_eval_ctx_new.call();
        return OPAAddr.newAddr(ctxAddr);
    }

    @Override
    public void opaEvalCtxSetInput(OPAAddr ctxAddr, OPAAddr inputAddr) {
        WasmFunctions.Consumer2 opa_eval_ctx_set_input = WasmFunctions.consumer(this.store, (Func)this.opaEvalCtxSetInputFn, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        opa_eval_ctx_set_input.accept((Object)ctxAddr.getInternal(), (Object)inputAddr.getInternal());
    }

    @Override
    public void opaEvalCtxSetData(OPAAddr ctxAddr, OPAAddr dataAddr) {
        WasmFunctions.Consumer2 opa_eval_ctx_set_data = WasmFunctions.consumer(this.store, (Func)this.opaEvalCtxSetDataFn, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        opa_eval_ctx_set_data.accept((Object)ctxAddr.getInternal(), (Object)dataAddr.getInternal());
    }

    @Override
    public OPAAddr opaEvalCtxGetResult(OPAAddr ctxAddr) {
        WasmFunctions.Function1 opa_eval_ctx_get_result = WasmFunctions.func(this.store, (Func)this.opaEvalCtxGetResultFn, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        int valueAddr = (Integer)opa_eval_ctx_get_result.call((Object)ctxAddr.getInternal());
        return OPAAddr.newAddr(valueAddr);
    }

    @Override
    public OPAAddr builtins() {
        WasmFunctions.Function0 builtins = WasmFunctions.func(this.store, (Func)this.builtinsFn, (WasmValType)WasmValType.I32);
        int valueAddr = (Integer)builtins.call();
        return OPAAddr.newAddr(valueAddr);
    }

    @Override
    public OPAErrorCode eval(OPAAddr ctxAddr) {
        WasmFunctions.Function1 eval = WasmFunctions.func(this.store, (Func)this.evalFn, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        int errorCode = (Integer)eval.call((Object)ctxAddr.getInternal());
        return OPAErrorCode.fromValue(errorCode);
    }

    @Override
    public OPAAddr entrypoints() {
        WasmFunctions.Function0 entrypoints = WasmFunctions.func(this.store, (Func)this.entrypointsFn, (WasmValType)WasmValType.I32);
        int valueAddr = (Integer)entrypoints.call();
        return OPAAddr.newAddr(valueAddr);
    }

    @Override
    public void opaEvalCtxSetEntryPoint(OPAAddr ctxAddr, int entrypoint_id) {
        WasmFunctions.Consumer2 opa_eval_ctx_set_entrypoint = WasmFunctions.consumer(this.store, (Func)this.opaEvalCtxSetEntryPointFn, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        opa_eval_ctx_set_entrypoint.accept((Object)ctxAddr.getInternal(), (Object)entrypoint_id);
    }

    @Override
    public void opaFree(OPAAddr addr) {
        WasmFunctions.Consumer1 opa_free = WasmFunctions.consumer(this.store, (Func)this.opaFreeFn, (WasmValType)WasmValType.I32);
        opa_free.accept((Object)addr.getInternal());
    }

    @Override
    public OPAAddr opaValueParse(OPAAddr addr, int jsonLength) {
        WasmFunctions.Function2 opa_value_parse = WasmFunctions.func(this.store, (Func)this.opaValueParseFn, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        int valueAddr = (Integer)opa_value_parse.call((Object)addr.getInternal(), (Object)jsonLength);
        return OPAAddr.newAddr(valueAddr);
    }

    @Override
    public OPAAddr opaValueDump(OPAAddr valueAddr) {
        WasmFunctions.Function1 opa_value_dump = WasmFunctions.func(this.store, (Func)this.opaValueDumpFn, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        int strAddr = (Integer)opa_value_dump.call((Object)valueAddr.getInternal());
        return OPAAddr.newAddr(strAddr);
    }

    @Override
    public OPAErrorCode opaValueAddPath(OPAAddr baseValueAddr, OPAAddr pathValueAddr, OPAAddr valueAddr) {
        WasmFunctions.Function3 opa_value_add_path = WasmFunctions.func(this.store, (Func)this.opaValueAddPathFn, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        int errorCode = (Integer)opa_value_add_path.call((Object)baseValueAddr.getInternal(), (Object)pathValueAddr.getInternal(), (Object)valueAddr.getInternal());
        return OPAErrorCode.fromValue(errorCode);
    }

    @Override
    public OPAErrorCode opaValueRemovePath(OPAAddr baseValueAddr, OPAAddr pathValueAddr) {
        WasmFunctions.Function2 opa_value_remove_path = WasmFunctions.func(this.store, (Func)this.opaValueRemovePathFn, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        int errorCode = (Integer)opa_value_remove_path.call((Object)baseValueAddr.getInternal(), (Object)pathValueAddr.getInternal());
        return OPAErrorCode.fromValue(errorCode);
    }

    @Override
    public OPAAddr opaEval(OPAAddr reservedAddr, int entrypoint_id, OPAAddr valueAddr, OPAAddr strAddr, int length, OPAAddr heapAddr, int format) {
        if (this.opaEvalFn == null) {
            throw new UnsupportedOperationException("opa_eval not supported, may be compiled using unsupported ABI(<1.2)");
        }
        WasmFunctions.Function7 opa_eval = WasmFunctions.func(this.store, (Func)this.opaEvalFn, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        int resultStrAddr = (Integer)opa_eval.call((Object)reservedAddr.getInternal(), (Object)entrypoint_id, (Object)valueAddr.getInternal(), (Object)strAddr.getInternal(), (Object)length, (Object)heapAddr.getInternal(), (Object)format);
        return OPAAddr.newAddr(resultStrAddr);
    }

    @Override
    public boolean isFastPathEvalSupported() {
        return this.opaEvalFn != null;
    }

    @Override
    public Integer getAbiMajorVersion() {
        return this.abiMajorVersion;
    }

    @Override
    public Integer getAbiMinorVersion() {
        return this.abiMinorVersion;
    }
}

