/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.permission;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.widget.Toast;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.sangcomz.fishbun.R;
import com.sangcomz.fishbun.define.Define;

public class PermissionCheck {
    private Context context;

    public PermissionCheck(Context context) {
        this.context = context;
    }

    @TargetApi(value=23)
    public boolean CheckStoragePermission() {
        Define define = new Define();
        int permissionCheckRead = ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.READ_EXTERNAL_STORAGE");
        int permissionCheckWrite = ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
        if (permissionCheckRead != 0 || permissionCheckWrite != 0) {
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)this.context), (String)"android.permission.READ_EXTERNAL_STORAGE")) {
                ActivityCompat.requestPermissions((Activity)((Activity)this.context), (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, (int)define.PERMISSION_STORAGE);
            } else {
                ActivityCompat.requestPermissions((Activity)((Activity)this.context), (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, (int)define.PERMISSION_STORAGE);
            }
            return false;
        }
        return true;
    }

    @TargetApi(value=23)
    public boolean CheckCameraPermission() {
        try {
            PackageInfo info = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 4096);
            String[] permissions = info.requestedPermissions;
            if (permissions != null && permissions.length > 0) {
                for (String permission2 : permissions) {
                    if (!permission2.equals("android.permission.CAMERA")) continue;
                    Define define = new Define();
                    int cameraPermission = ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.CAMERA");
                    if (cameraPermission != 0) {
                        if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)this.context), (String)"android.permission.CAMERA")) {
                            Activity activity = (Activity)this.context;
                            String[] stringArray = new String[]{"android.permission.CAMERA"};
                            define.getClass();
                            ActivityCompat.requestPermissions((Activity)activity, (String[])stringArray, (int)29);
                        } else {
                            Activity activity = (Activity)this.context;
                            String[] stringArray = new String[]{"android.permission.CAMERA"};
                            define.getClass();
                            ActivityCompat.requestPermissions((Activity)activity, (String[])stringArray, (int)29);
                        }
                        return false;
                    }
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void showPermissionDialog() {
        Toast.makeText((Context)this.context, (int)R.string.msg_permission, (int)0).show();
    }
}

