/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.timelimiter.internal;

import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.github.resilience4j.timelimiter.event.TimeLimiterEvent;
import io.github.resilience4j.timelimiter.event.TimeLimiterOnErrorEvent;
import io.github.resilience4j.timelimiter.event.TimeLimiterOnSuccessEvent;
import io.github.resilience4j.timelimiter.event.TimeLimiterOnTimeoutEvent;
import io.github.resilience4j.timelimiter.internal.TimeLimiterEventProcessor;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeLimiterImpl
implements TimeLimiter {
    private static final Logger LOG = LoggerFactory.getLogger(TimeLimiterImpl.class);
    private String name;
    private final TimeLimiterConfig timeLimiterConfig;
    private final TimeLimiterEventProcessor eventProcessor;

    public TimeLimiterImpl(String name, TimeLimiterConfig timeLimiterConfig) {
        this.name = name;
        this.timeLimiterConfig = timeLimiterConfig;
        this.eventProcessor = new TimeLimiterEventProcessor();
    }

    @Override
    public <T, F extends Future<T>> Callable<T> decorateFutureSupplier(Supplier<F> futureSupplier) {
        return () -> {
            Future future = (Future)futureSupplier.get();
            try {
                Object result = future.get(this.getTimeLimiterConfig().getTimeoutDuration().toMillis(), TimeUnit.MILLISECONDS);
                this.onSuccess();
                return result;
            }
            catch (TimeoutException e) {
                this.onError(e);
                if (this.getTimeLimiterConfig().shouldCancelRunningFuture()) {
                    future.cancel(true);
                }
                throw e;
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                if (t == null) {
                    this.onError(e);
                    throw e;
                }
                this.onError(t);
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw (Exception)t;
            }
        };
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TimeLimiterConfig getTimeLimiterConfig() {
        return this.timeLimiterConfig;
    }

    @Override
    public TimeLimiter.EventPublisher getEventPublisher() {
        return this.eventProcessor;
    }

    @Override
    public void onSuccess() {
        if (!this.eventProcessor.hasConsumers()) {
            return;
        }
        this.publishEvent(new TimeLimiterOnSuccessEvent(this.name));
    }

    @Override
    public void onError(Throwable throwable) {
        if (throwable instanceof TimeoutException) {
            this.onTimeout();
        } else {
            this.onFailure(throwable);
        }
    }

    private void onTimeout() {
        if (!this.eventProcessor.hasConsumers()) {
            return;
        }
        this.publishEvent(new TimeLimiterOnTimeoutEvent(this.name));
    }

    private void onFailure(Throwable throwable) {
        if (!this.eventProcessor.hasConsumers()) {
            return;
        }
        this.publishEvent(new TimeLimiterOnErrorEvent(this.name, throwable));
    }

    private void publishEvent(TimeLimiterEvent event) {
        try {
            this.eventProcessor.consumeEvent(event);
            LOG.debug("Event {} published: {}", (Object)event.getEventType(), (Object)event);
        }
        catch (Throwable t) {
            LOG.warn("Failed to handle event {}", (Object)event.getEventType(), (Object)t);
        }
    }
}

