/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.timelimiter.internal;

import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.registry.AbstractRegistry;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import io.github.resilience4j.timelimiter.internal.TimeLimiterImpl;
import io.vavr.collection.Array;
import io.vavr.collection.Seq;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class InMemoryTimeLimiterRegistry
extends AbstractRegistry<TimeLimiter, TimeLimiterConfig>
implements TimeLimiterRegistry {
    public InMemoryTimeLimiterRegistry() {
        this(TimeLimiterConfig.ofDefaults());
    }

    public InMemoryTimeLimiterRegistry(Map<String, TimeLimiterConfig> configs) {
        this(configs.getOrDefault("default", TimeLimiterConfig.ofDefaults()));
        this.configurations.putAll(configs);
    }

    public InMemoryTimeLimiterRegistry(Map<String, TimeLimiterConfig> configs, RegistryEventConsumer<TimeLimiter> registryEventConsumer) {
        this(configs.getOrDefault("default", TimeLimiterConfig.ofDefaults()), registryEventConsumer);
        this.configurations.putAll(configs);
    }

    public InMemoryTimeLimiterRegistry(Map<String, TimeLimiterConfig> configs, List<RegistryEventConsumer<TimeLimiter>> registryEventConsumers) {
        this(configs.getOrDefault("default", TimeLimiterConfig.ofDefaults()), registryEventConsumers);
        this.configurations.putAll(configs);
    }

    public InMemoryTimeLimiterRegistry(TimeLimiterConfig defaultConfig) {
        super((Object)defaultConfig);
    }

    public InMemoryTimeLimiterRegistry(TimeLimiterConfig defaultConfig, RegistryEventConsumer<TimeLimiter> registryEventConsumer) {
        super((Object)defaultConfig, registryEventConsumer);
    }

    public InMemoryTimeLimiterRegistry(TimeLimiterConfig defaultConfig, List<RegistryEventConsumer<TimeLimiter>> registryEventConsumers) {
        super((Object)defaultConfig, registryEventConsumers);
    }

    @Override
    public Seq<TimeLimiter> getAllTimeLimiters() {
        return Array.ofAll(this.entryMap.values());
    }

    @Override
    public TimeLimiter timeLimiter(String name) {
        return this.timeLimiter(name, (TimeLimiterConfig)this.getDefaultConfig());
    }

    @Override
    public TimeLimiter timeLimiter(String name, TimeLimiterConfig config) {
        return (TimeLimiter)this.computeIfAbsent(name, () -> new TimeLimiterImpl(name, Objects.requireNonNull(config, "Config must not be null")));
    }

    @Override
    public TimeLimiter timeLimiter(String name, Supplier<TimeLimiterConfig> timeLimiterConfigSupplier) {
        return (TimeLimiter)this.computeIfAbsent(name, () -> {
            TimeLimiterConfig config = (TimeLimiterConfig)Objects.requireNonNull(timeLimiterConfigSupplier, "Supplier must not be null").get();
            return new TimeLimiterImpl(name, Objects.requireNonNull(config, "Config must not be null"));
        });
    }

    @Override
    public TimeLimiter timeLimiter(String name, String configName) {
        return (TimeLimiter)this.computeIfAbsent(name, () -> {
            TimeLimiterConfig config = (TimeLimiterConfig)this.getConfiguration(configName).orElseThrow(() -> new ConfigurationNotFoundException(configName));
            return TimeLimiter.of(name, config);
        });
    }
}

