/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.timelimiter;

import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.github.resilience4j.timelimiter.internal.TimeLimiterImpl;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public interface TimeLimiter {
    public static TimeLimiter ofDefaults() {
        return new TimeLimiterImpl(TimeLimiterConfig.ofDefaults());
    }

    public static TimeLimiter of(TimeLimiterConfig timeLimiterConfig) {
        return new TimeLimiterImpl(timeLimiterConfig);
    }

    public static TimeLimiter of(Duration timeoutDuration) {
        TimeLimiterConfig timeLimiterConfig = TimeLimiterConfig.custom().timeoutDuration(timeoutDuration).build();
        return new TimeLimiterImpl(timeLimiterConfig);
    }

    public static <T, F extends Future<T>> Callable<T> decorateFutureSupplier(TimeLimiter timeLimiter, Supplier<F> futureSupplier) {
        return () -> {
            Future future = (Future)futureSupplier.get();
            try {
                return future.get(timeLimiter.getTimeLimiterConfig().getTimeoutDuration().toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                if (timeLimiter.getTimeLimiterConfig().shouldCancelRunningFuture()) {
                    future.cancel(true);
                }
                throw e;
            }
        };
    }

    public TimeLimiterConfig getTimeLimiterConfig();

    default public <T, F extends Future<T>> T executeFutureSupplier(Supplier<F> futureSupplier) throws Exception {
        return TimeLimiter.decorateFutureSupplier(this, futureSupplier).call();
    }
}

