/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.configure;

import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryRegistry;
import io.github.resilience4j.retry.configure.RetryAspectExt;
import io.github.resilience4j.retry.configure.RetryConfigurationProperties;
import io.vavr.CheckedFunction0;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;

@Aspect
public class RetryAspect
implements Ordered {
    private static final Logger logger = LoggerFactory.getLogger(RetryAspect.class);
    private static final ScheduledExecutorService retryExecutorService = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    private final RetryConfigurationProperties retryConfigurationProperties;
    private final RetryRegistry retryRegistry;
    private final List<RetryAspectExt> retryAspectExtList;

    public RetryAspect(RetryConfigurationProperties retryConfigurationProperties, RetryRegistry retryRegistry, @Autowired(required=false) List<RetryAspectExt> retryAspectExtList) {
        this.retryConfigurationProperties = retryConfigurationProperties;
        this.retryRegistry = retryRegistry;
        this.retryAspectExtList = retryAspectExtList;
        this.cleanup();
    }

    @Pointcut(value="@within(retry) || @annotation(retry)", argNames="retry")
    public void matchAnnotatedClassOrMethod(io.github.resilience4j.retry.annotation.Retry retry) {
    }

    @Around(value="matchAnnotatedClassOrMethod(backendMonitored)", argNames="proceedingJoinPoint, backendMonitored")
    public Object retryAroundAdvice(ProceedingJoinPoint proceedingJoinPoint, io.github.resilience4j.retry.annotation.Retry backendMonitored) throws Throwable {
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        String methodName = method.getDeclaringClass().getName() + "#" + method.getName();
        if (backendMonitored == null) {
            backendMonitored = this.getBackendMonitoredAnnotation(proceedingJoinPoint);
        }
        String backend = backendMonitored.name();
        Retry retry = this.getOrCreateRetry(methodName, backend);
        Class<?> returnType = method.getReturnType();
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            return this.handleJoinPointCompletableFuture(proceedingJoinPoint, retry, methodName);
        }
        if (this.retryAspectExtList != null && !this.retryAspectExtList.isEmpty()) {
            for (RetryAspectExt retryAspectExt : this.retryAspectExtList) {
                if (!retryAspectExt.canHandleReturnType(returnType)) continue;
                return retryAspectExt.handle(proceedingJoinPoint, retry, methodName);
            }
        }
        return this.handleDefaultJoinPoint(proceedingJoinPoint, retry, methodName);
    }

    private Retry getOrCreateRetry(String methodName, String backend) {
        Retry retry = this.retryRegistry.retry(backend, () -> this.retryConfigurationProperties.createRetryConfig(backend));
        if (logger.isDebugEnabled()) {
            logger.debug("Created or retrieved retry '{}' with max attempts rate '{}'  for method: '{}'", new Object[]{backend, retry.getRetryConfig().getResultPredicate(), methodName});
        }
        return retry;
    }

    private io.github.resilience4j.retry.annotation.Retry getBackendMonitoredAnnotation(ProceedingJoinPoint proceedingJoinPoint) {
        if (logger.isDebugEnabled()) {
            logger.debug("circuitBreaker parameter is null");
        }
        io.github.resilience4j.retry.annotation.Retry retry = null;
        Class<?> targetClass = proceedingJoinPoint.getTarget().getClass();
        if (targetClass.isAnnotationPresent(io.github.resilience4j.retry.annotation.Retry.class) && (retry = targetClass.getAnnotation(io.github.resilience4j.retry.annotation.Retry.class)) == null && logger.isDebugEnabled()) {
            logger.debug("TargetClass has no annotation 'Retry'");
            retry = targetClass.getDeclaredAnnotation(io.github.resilience4j.retry.annotation.Retry.class);
            if (retry == null && logger.isDebugEnabled()) {
                logger.debug("TargetClass has no declared annotation 'Retry'");
            }
        }
        return retry;
    }

    private Object handleDefaultJoinPoint(ProceedingJoinPoint proceedingJoinPoint, Retry retry, String methodName) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug("retry invocation of method {} ", (Object)methodName);
        }
        CheckedFunction0 objectCheckedFunction0 = Retry.decorateCheckedSupplier((Retry)retry, () -> ((ProceedingJoinPoint)proceedingJoinPoint).proceed());
        return objectCheckedFunction0.apply();
    }

    private Object handleJoinPointCompletableFuture(ProceedingJoinPoint proceedingJoinPoint, Retry retry, String methodName) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug("async retry invocation of method {} ", (Object)methodName);
        }
        return Retry.decorateCompletionStage((Retry)retry, (ScheduledExecutorService)retryExecutorService, () -> {
            try {
                return (CompletionStage)proceedingJoinPoint.proceed();
            }
            catch (Throwable throwable) {
                throw new CompletionException(throwable);
            }
        }).get();
    }

    public int getOrder() {
        return this.retryConfigurationProperties.getRetryAspectOrder();
    }

    private void cleanup() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            retryExecutorService.shutdown();
            try {
                if (!retryExecutorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    retryExecutorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                if (!retryExecutorService.isTerminated()) {
                    retryExecutorService.shutdownNow();
                }
                Thread.currentThread().interrupt();
            }
        }));
    }
}

