/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.configure;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.configure.RateLimiterConfigurationProperties;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

@Aspect
public class RateLimiterAspect
implements Ordered {
    public static final String RATE_LIMITER_RECEIVED = "Created or retrieved rate limiter '{}' with period: '{}'; limit for period: '{}'; timeout: '{}'; method: '{}'";
    private static final Logger logger = LoggerFactory.getLogger(RateLimiterAspect.class);
    private final RateLimiterRegistry rateLimiterRegistry;
    private final RateLimiterConfigurationProperties properties;

    public RateLimiterAspect(RateLimiterRegistry rateLimiterRegistry, RateLimiterConfigurationProperties properties) {
        this.rateLimiterRegistry = rateLimiterRegistry;
        this.properties = properties;
    }

    @Pointcut(value="@within(rateLimiter) || @annotation(rateLimiter)", argNames="rateLimiter")
    public void matchAnnotatedClassOrMethod(io.github.resilience4j.ratelimiter.annotation.RateLimiter rateLimiter) {
    }

    @Around(value="matchAnnotatedClassOrMethod(limitedService)", argNames="proceedingJoinPoint, limitedService")
    public Object rateLimiterAroundAdvice(ProceedingJoinPoint proceedingJoinPoint, io.github.resilience4j.ratelimiter.annotation.RateLimiter limitedService) throws Throwable {
        io.github.resilience4j.ratelimiter.annotation.RateLimiter targetService = limitedService;
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        String methodName = method.getDeclaringClass().getName() + "#" + method.getName();
        if (targetService == null) {
            targetService = this.getRateLimiterAnnotation(proceedingJoinPoint);
        }
        String name = targetService.name();
        RateLimiter rateLimiter = this.getOrCreateRateLimiter(methodName, name);
        return this.handleJoinPoint(proceedingJoinPoint, rateLimiter, methodName);
    }

    private RateLimiter getOrCreateRateLimiter(String methodName, String name) {
        RateLimiter rateLimiter = this.rateLimiterRegistry.rateLimiter(name);
        if (logger.isDebugEnabled()) {
            RateLimiterConfig rateLimiterConfig = rateLimiter.getRateLimiterConfig();
            logger.debug(RATE_LIMITER_RECEIVED, new Object[]{name, rateLimiterConfig.getLimitRefreshPeriod(), rateLimiterConfig.getLimitForPeriod(), rateLimiterConfig.getTimeoutDuration(), methodName});
        }
        return rateLimiter;
    }

    private io.github.resilience4j.ratelimiter.annotation.RateLimiter getRateLimiterAnnotation(ProceedingJoinPoint proceedingJoinPoint) {
        io.github.resilience4j.ratelimiter.annotation.RateLimiter rateLimiter = null;
        Class<?> targetClass = proceedingJoinPoint.getTarget().getClass();
        if (targetClass.isAnnotationPresent(io.github.resilience4j.ratelimiter.annotation.RateLimiter.class)) {
            rateLimiter = targetClass.getAnnotation(io.github.resilience4j.ratelimiter.annotation.RateLimiter.class);
            if (rateLimiter == null) {
                rateLimiter = targetClass.getDeclaredAnnotation(io.github.resilience4j.ratelimiter.annotation.RateLimiter.class);
            }
            if (rateLimiter == null) {
                logger.debug("TargetClass has no declared annotation 'RateLimiter'");
            }
        }
        return rateLimiter;
    }

    private Object handleJoinPoint(ProceedingJoinPoint proceedingJoinPoint, RateLimiter rateLimiter, String methodName) throws Throwable {
        try {
            RateLimiter.waitForPermission((RateLimiter)rateLimiter);
            return proceedingJoinPoint.proceed();
        }
        catch (Exception exception) {
            if (logger.isDebugEnabled()) {
                logger.debug("Invocation of method '" + methodName + "' failed!", (Throwable)exception);
            }
            throw exception;
        }
    }

    public int getOrder() {
        return this.properties.getRateLimiterAspectOrder();
    }
}

