/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.rxjava3.timelimiter.transformer;

import io.github.resilience4j.timelimiter.TimeLimiter;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.CompletableTransformer;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.MaybeTransformer;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.core.SingleTransformer;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;

public class TimeLimiterTransformer<T>
implements FlowableTransformer<T, T>,
ObservableTransformer<T, T>,
SingleTransformer<T, T>,
CompletableTransformer,
MaybeTransformer<T, T> {
    private final TimeLimiter timeLimiter;

    private TimeLimiterTransformer(TimeLimiter timeLimiter) {
        this.timeLimiter = timeLimiter;
    }

    public static <T> TimeLimiterTransformer<T> of(TimeLimiter timeLimiter) {
        return new TimeLimiterTransformer<T>(timeLimiter);
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return upstream.timeout(this.getTimeoutInMillis(), TimeUnit.MILLISECONDS).doOnNext(t -> this.timeLimiter.onSuccess()).doOnComplete(() -> ((TimeLimiter)this.timeLimiter).onSuccess()).doOnError(arg_0 -> ((TimeLimiter)this.timeLimiter).onError(arg_0));
    }

    public ObservableSource<T> apply(Observable<T> upstream) {
        return upstream.timeout(this.getTimeoutInMillis(), TimeUnit.MILLISECONDS).doOnNext(t -> this.timeLimiter.onSuccess()).doOnComplete(() -> ((TimeLimiter)this.timeLimiter).onSuccess()).doOnError(arg_0 -> ((TimeLimiter)this.timeLimiter).onError(arg_0));
    }

    public SingleSource<T> apply(Single<T> upstream) {
        return upstream.timeout(this.getTimeoutInMillis(), TimeUnit.MILLISECONDS).doOnSuccess(t -> this.timeLimiter.onSuccess()).doOnError(arg_0 -> ((TimeLimiter)this.timeLimiter).onError(arg_0));
    }

    public CompletableSource apply(Completable upstream) {
        return upstream.timeout(this.getTimeoutInMillis(), TimeUnit.MILLISECONDS).doOnComplete(() -> ((TimeLimiter)this.timeLimiter).onSuccess()).doOnError(arg_0 -> ((TimeLimiter)this.timeLimiter).onError(arg_0));
    }

    public MaybeSource<T> apply(Maybe<T> upstream) {
        return upstream.timeout(this.getTimeoutInMillis(), TimeUnit.MILLISECONDS).doOnSuccess(t -> this.timeLimiter.onSuccess()).doOnComplete(() -> ((TimeLimiter)this.timeLimiter).onSuccess()).doOnError(arg_0 -> ((TimeLimiter)this.timeLimiter).onError(arg_0));
    }

    private long getTimeoutInMillis() {
        return this.timeLimiter.getTimeLimiterConfig().getTimeoutDuration().toMillis();
    }
}

