/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.operator;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.operator.CompletableBulkhead;
import io.github.resilience4j.bulkhead.operator.FlowableBulkhead;
import io.github.resilience4j.bulkhead.operator.MaybeBulkhead;
import io.github.resilience4j.bulkhead.operator.ObserverBulkhead;
import io.github.resilience4j.bulkhead.operator.SingleBulkhead;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.CompletableTransformer;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.MaybeTransformer;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.SingleTransformer;
import java.util.Objects;
import org.reactivestreams.Publisher;

public class BulkheadOperator<T>
implements FlowableTransformer<T, T>,
SingleTransformer<T, T>,
MaybeTransformer<T, T>,
CompletableTransformer,
ObservableTransformer<T, T> {
    private final Bulkhead bulkhead;

    private BulkheadOperator(Bulkhead bulkhead) {
        this.bulkhead = Objects.requireNonNull(bulkhead);
    }

    public static <T> BulkheadOperator<T> of(Bulkhead bulkhead) {
        return new BulkheadOperator<T>(bulkhead);
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new FlowableBulkhead<T>(upstream, this.bulkhead);
    }

    public SingleSource<T> apply(Single<T> upstream) {
        return new SingleBulkhead<T>(upstream, this.bulkhead);
    }

    public CompletableSource apply(Completable upstream) {
        return new CompletableBulkhead(upstream, this.bulkhead);
    }

    public MaybeSource<T> apply(Maybe<T> upstream) {
        return new MaybeBulkhead<T>(upstream, this.bulkhead);
    }

    public ObservableSource<T> apply(Observable<T> upstream) {
        return new ObserverBulkhead<T>(upstream, this.bulkhead);
    }
}

