/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.operator;

import io.github.resilience4j.AbstractObserver;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.core.StopWatch;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;

class ObserverCircuitBreaker<T>
extends Observable<T> {
    private final Observable<T> upstream;
    private final CircuitBreaker circuitBreaker;

    ObserverCircuitBreaker(Observable<T> upstream, CircuitBreaker circuitBreaker) {
        this.upstream = upstream;
        this.circuitBreaker = circuitBreaker;
    }

    protected void subscribeActual(Observer<? super T> downstream) {
        if (this.circuitBreaker.tryAcquirePermission()) {
            this.upstream.subscribe((Observer)new CircuitBreakerObserver(downstream));
        } else {
            downstream.onSubscribe((Disposable)EmptyDisposable.INSTANCE);
            downstream.onError((Throwable)new CallNotPermittedException(this.circuitBreaker));
        }
    }

    class CircuitBreakerObserver
    extends AbstractObserver<T> {
        private final StopWatch stopWatch;

        CircuitBreakerObserver(Observer<? super T> downstreamObserver) {
            super(downstreamObserver);
            this.stopWatch = StopWatch.start();
        }

        @Override
        protected void hookOnError(Throwable e) {
            ObserverCircuitBreaker.this.circuitBreaker.onError(this.stopWatch.stop().toNanos(), e);
        }

        @Override
        protected void hookOnComplete() {
            ObserverCircuitBreaker.this.circuitBreaker.onSuccess(this.stopWatch.stop().toNanos());
        }

        @Override
        protected void hookOnCancel() {
            ObserverCircuitBreaker.this.circuitBreaker.releasePermission();
        }
    }
}

