/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j;

import io.github.resilience4j.AbstractDisposable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.util.Objects;

public abstract class AbstractObserver<T>
extends AbstractDisposable
implements Observer<T> {
    private final Observer<? super T> downstreamObserver;

    public AbstractObserver(Observer<? super T> downstreamObserver) {
        this.downstreamObserver = Objects.requireNonNull(downstreamObserver);
    }

    @Override
    protected void hookOnSubscribe() {
        this.downstreamObserver.onSubscribe((Disposable)this);
    }

    public void onNext(T item) {
        this.whenNotDisposed(() -> this.downstreamObserver.onNext(item));
    }

    public void onError(Throwable e) {
        this.whenNotCompleted(() -> {
            this.hookOnError(e);
            this.downstreamObserver.onError(e);
        });
    }

    protected abstract void hookOnError(Throwable var1);

    public void onComplete() {
        this.whenNotCompleted(() -> {
            this.hookOnComplete();
            this.downstreamObserver.onComplete();
        });
    }

    protected abstract void hookOnComplete();
}

