/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.operator;

import io.github.resilience4j.AbstractSubscriber;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.core.StopWatch;
import io.reactivex.Flowable;
import io.reactivex.internal.subscriptions.EmptySubscription;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class FlowableCircuitBreaker<T>
extends Flowable<T> {
    private final CircuitBreaker circuitBreaker;
    private final Publisher<T> upstream;

    FlowableCircuitBreaker(Publisher<T> upstream, CircuitBreaker circuitBreaker) {
        this.circuitBreaker = Objects.requireNonNull(circuitBreaker);
        this.upstream = Objects.requireNonNull(upstream, "source is null");
    }

    protected void subscribeActual(Subscriber<? super T> downstream) {
        if (this.circuitBreaker.tryAcquirePermission()) {
            this.upstream.subscribe((Subscriber)new CircuitBreakerSubscriber(downstream));
        } else {
            downstream.onSubscribe((Subscription)EmptySubscription.INSTANCE);
            downstream.onError((Throwable)new CallNotPermittedException(this.circuitBreaker));
        }
    }

    class CircuitBreakerSubscriber
    extends AbstractSubscriber<T> {
        private final StopWatch stopWatch;

        CircuitBreakerSubscriber(Subscriber<? super T> downstreamSubscriber) {
            super(downstreamSubscriber);
            this.stopWatch = StopWatch.start();
        }

        @Override
        public void hookOnError(Throwable t) {
            FlowableCircuitBreaker.this.circuitBreaker.onError(this.stopWatch.stop().toNanos(), t);
        }

        @Override
        public void hookOnComplete() {
            FlowableCircuitBreaker.this.circuitBreaker.onSuccess(this.stopWatch.stop().toNanos());
        }

        @Override
        public void hookOnCancel() {
            FlowableCircuitBreaker.this.circuitBreaker.releasePermission();
        }
    }
}

