/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.operator;

import io.github.resilience4j.adapter.Permit;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerOpenException;
import io.github.resilience4j.core.StopWatch;
import io.github.resilience4j.core.lang.Nullable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

class DisposableCircuitBreaker<T>
extends AtomicReference<Disposable>
implements Disposable {
    private final CircuitBreaker circuitBreaker;
    @Nullable
    private StopWatch stopWatch;
    private final AtomicReference<Permit> permitted = new AtomicReference<Permit>(Permit.PENDING);

    DisposableCircuitBreaker(CircuitBreaker circuitBreaker) {
        this.circuitBreaker = Objects.requireNonNull(circuitBreaker);
    }

    public final void dispose() {
        DisposableHelper.dispose((AtomicReference)this);
    }

    public final boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)((Disposable)this.get()));
    }

    protected void onSubscribeInner(Disposable disposable) {
    }

    protected final void onSubscribeWithPermit(Disposable disposable) {
        if (DisposableHelper.setOnce((AtomicReference)this, (Disposable)disposable)) {
            if (this.acquireCallPermit()) {
                this.onSubscribeInner(this);
            } else {
                this.dispose();
                this.onSubscribeInner(this);
                this.permittedOnError(this.circuitBreakerOpenException());
            }
        }
    }

    protected void permittedOnError(Throwable e) {
    }

    protected final void onErrorInner(Throwable e) {
        this.markFailure(e);
        if (this.isInvocationPermitted()) {
            this.permittedOnError(e);
        }
    }

    protected void permittedOnComplete() {
    }

    protected final void onCompleteInner() {
        this.markSuccess();
        if (this.isInvocationPermitted()) {
            this.permittedOnComplete();
        }
    }

    protected void permittedOnSuccess(T value) {
    }

    protected final void onSuccessInner(T value) {
        this.markSuccess();
        if (this.isInvocationPermitted()) {
            this.permittedOnSuccess(value);
        }
    }

    protected void permittedOnNext(T value) {
    }

    protected final void onNextInner(T value) {
        if (this.isInvocationPermitted()) {
            this.permittedOnNext(value);
        }
    }

    private boolean acquireCallPermit() {
        boolean callPermitted = false;
        if (this.permitted.compareAndSet(Permit.PENDING, Permit.ACQUIRED)) {
            callPermitted = this.circuitBreaker.isCallPermitted();
            if (!callPermitted) {
                this.permitted.set(Permit.REJECTED);
            } else {
                this.stopWatch = StopWatch.start((String)this.circuitBreaker.getName());
            }
        }
        return callPermitted;
    }

    private boolean isInvocationPermitted() {
        return !this.isDisposed() && this.wasCallPermitted();
    }

    private Exception circuitBreakerOpenException() {
        return new CircuitBreakerOpenException(String.format("CircuitBreaker '%s' is open", this.circuitBreaker.getName()));
    }

    private void markFailure(Throwable e) {
        if (this.wasCallPermitted()) {
            this.circuitBreaker.onError(this.stopWatch.stop().getProcessingDuration().toNanos(), e);
        }
    }

    private void markSuccess() {
        if (this.wasCallPermitted()) {
            this.circuitBreaker.onSuccess(this.stopWatch.stop().getProcessingDuration().toNanos());
        }
    }

    private boolean wasCallPermitted() {
        return this.permitted.get() == Permit.ACQUIRED;
    }
}

