/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.operator;

import io.github.resilience4j.adapter.Permit;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerOpenException;
import io.github.resilience4j.core.StopWatch;
import io.github.resilience4j.core.lang.Nullable;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class CircuitBreakerSubscriber<T>
extends AtomicReference<Subscription>
implements Subscriber<T>,
Subscription {
    private final CircuitBreaker circuitBreaker;
    private final Subscriber<? super T> childSubscriber;
    private final AtomicReference<Permit> permitted = new AtomicReference<Permit>(Permit.PENDING);
    @Nullable
    private StopWatch stopWatch;

    CircuitBreakerSubscriber(CircuitBreaker circuitBreaker, Subscriber<? super T> childSubscriber) {
        this.circuitBreaker = Objects.requireNonNull(circuitBreaker);
        this.childSubscriber = Objects.requireNonNull(childSubscriber);
    }

    public void onSubscribe(Subscription subscription) {
        if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)subscription)) {
            if (this.acquireCallPermit()) {
                this.childSubscriber.onSubscribe((Subscription)this);
            } else {
                this.cancel();
                this.childSubscriber.onSubscribe((Subscription)this);
                this.childSubscriber.onError((Throwable)new CircuitBreakerOpenException(String.format("CircuitBreaker '%s' is open", this.circuitBreaker.getName())));
            }
        }
    }

    public void onNext(T event) {
        if (this.isInvocationPermitted()) {
            this.childSubscriber.onNext(event);
        }
    }

    public void onError(Throwable e) {
        this.markFailure(e);
        if (this.isInvocationPermitted()) {
            this.childSubscriber.onError(e);
        }
    }

    public void onComplete() {
        this.markSuccess();
        if (this.isInvocationPermitted()) {
            this.childSubscriber.onComplete();
        }
    }

    public void request(long n) {
        ((Subscription)this.get()).request(n);
    }

    public void cancel() {
        SubscriptionHelper.cancel((AtomicReference)this);
    }

    private boolean acquireCallPermit() {
        boolean callPermitted = false;
        if (this.permitted.compareAndSet(Permit.PENDING, Permit.ACQUIRED)) {
            callPermitted = this.circuitBreaker.isCallPermitted();
            if (!callPermitted) {
                this.permitted.set(Permit.REJECTED);
            } else {
                this.stopWatch = StopWatch.start((String)this.circuitBreaker.getName());
            }
        }
        return callPermitted;
    }

    private boolean isInvocationPermitted() {
        return this.notCancelled() && this.wasCallPermitted();
    }

    private boolean notCancelled() {
        return this.get() != SubscriptionHelper.CANCELLED;
    }

    private void markFailure(Throwable e) {
        if (this.wasCallPermitted()) {
            this.circuitBreaker.onError(this.stopWatch.stop().getProcessingDuration().toNanos(), e);
        }
    }

    private void markSuccess() {
        if (this.wasCallPermitted()) {
            this.circuitBreaker.onSuccess(this.stopWatch.stop().getProcessingDuration().toNanos());
        }
    }

    private boolean wasCallPermitted() {
        return this.permitted.get() == Permit.ACQUIRED;
    }
}

