/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.operator;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.reactivex.disposables.Disposable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

class DisposableBulkhead
implements Disposable {
    private Disposable disposable;
    private final Bulkhead bulkhead;
    private final AtomicBoolean disposed = new AtomicBoolean(false);
    private final AtomicBoolean permitted = new AtomicBoolean(false);

    DisposableBulkhead(Bulkhead bulkhead) {
        this.bulkhead = Objects.requireNonNull(bulkhead);
    }

    public void dispose() {
        if (this.disposed.compareAndSet(false, true)) {
            this.releaseBulkhead();
            this.disposable.dispose();
        }
    }

    public boolean isDisposed() {
        return this.disposed.get();
    }

    protected void setDisposable(Disposable disposable) {
        this.disposable = Objects.requireNonNull(disposable);
    }

    protected boolean acquireCallPermit() {
        boolean callPermitted = false;
        if (this.permitted.compareAndSet(false, true) && !(callPermitted = this.bulkhead.isCallPermitted())) {
            this.permitted.set(false);
        }
        return callPermitted;
    }

    protected boolean isInvocationPermitted() {
        return !this.isDisposed() && this.wasCallPermitted();
    }

    protected void releaseBulkhead() {
        if (this.wasCallPermitted()) {
            this.bulkhead.onComplete();
        }
    }

    protected Exception bulkheadFullException() {
        return new BulkheadFullException(String.format("Bulkhead '%s' is full", this.bulkhead.getName()));
    }

    private boolean wasCallPermitted() {
        return this.permitted.get();
    }
}

