/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.operator;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class BulkheadSubscriber<T>
implements Subscriber<T>,
Subscription {
    private final Bulkhead bulkhead;
    private final Subscriber<? super T> childSubscriber;
    private Subscription subscription;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final AtomicBoolean permitted = new AtomicBoolean(false);

    BulkheadSubscriber(Bulkhead bulkhead, Subscriber<? super T> childSubscriber) {
        this.bulkhead = Objects.requireNonNull(bulkhead);
        this.childSubscriber = Objects.requireNonNull(childSubscriber);
    }

    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        if (this.acquireCallPermit()) {
            this.childSubscriber.onSubscribe((Subscription)this);
        } else {
            this.cancel();
            this.childSubscriber.onSubscribe((Subscription)this);
            this.childSubscriber.onError((Throwable)new BulkheadFullException(String.format("Bulkhead '%s' is full", this.bulkhead.getName())));
        }
    }

    public void onNext(T event) {
        if (this.isInvocationPermitted()) {
            this.childSubscriber.onNext(event);
        }
    }

    public void onError(Throwable e) {
        if (this.isInvocationPermitted()) {
            this.bulkhead.onComplete();
            this.childSubscriber.onError(e);
        }
    }

    public void onComplete() {
        if (this.isInvocationPermitted()) {
            this.releaseBulkhead();
            this.childSubscriber.onComplete();
        }
    }

    public void request(long n) {
        this.subscription.request(n);
    }

    public void cancel() {
        if (this.cancelled.compareAndSet(false, true)) {
            this.releaseBulkhead();
            this.subscription.cancel();
        }
    }

    private boolean acquireCallPermit() {
        boolean callPermitted = false;
        if (this.permitted.compareAndSet(false, true) && !(callPermitted = this.bulkhead.isCallPermitted())) {
            this.permitted.set(false);
        }
        return callPermitted;
    }

    private boolean isInvocationPermitted() {
        return !this.cancelled.get() && this.wasCallPermitted();
    }

    private boolean wasCallPermitted() {
        return this.permitted.get();
    }

    private void releaseBulkhead() {
        if (this.wasCallPermitted()) {
            this.bulkhead.onComplete();
        }
    }
}

