/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry;

import io.github.resilience4j.retry.IntervalFunction;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class RetryConfig {
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    public static final long DEFAULT_WAIT_DURATION = 500L;
    public static final IntervalFunction DEFAULT_INTERVAL_FUNCTION = numOfAttempts -> 500L;
    public static final Predicate<Throwable> DEFAULT_RECORD_FAILURE_PREDICATE = throwable -> true;
    private int maxAttempts = 3;
    private IntervalFunction intervalFunction = DEFAULT_INTERVAL_FUNCTION;
    private Predicate<Throwable> exceptionPredicate = DEFAULT_RECORD_FAILURE_PREDICATE;

    private RetryConfig() {
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public Function<Integer, Long> getIntervalFunction() {
        return this.intervalFunction;
    }

    public Predicate<Throwable> getExceptionPredicate() {
        return this.exceptionPredicate;
    }

    public static Builder custom() {
        return new Builder();
    }

    public static RetryConfig ofDefaults() {
        return new Builder().build();
    }

    public static class Builder {
        private Predicate<Throwable> retryExceptionPredicate;
        private Predicate<Throwable> exceptionPredicate;
        private IntervalFunction intervalFunction = IntervalFunction.ofDefaults();
        private Class<? extends Throwable>[] retryExceptions = new Class[0];
        private Class<? extends Throwable>[] ignoreExceptions = new Class[0];
        private int maxAttempts = 3;

        public Builder maxAttempts(int maxAttempts) {
            if (maxAttempts < 1) {
                throw new IllegalArgumentException("maxAttempts must be greater than or equal to 1");
            }
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder waitDuration(Duration waitDuration) {
            if (waitDuration.toMillis() < 10L) {
                throw new IllegalArgumentException("waitDurationInOpenState must be at least 10ms");
            }
            this.intervalFunction = x -> waitDuration.toMillis();
            return this;
        }

        public Builder intervalFunction(IntervalFunction f) {
            this.intervalFunction = f;
            return this;
        }

        public Builder retryOnException(Predicate<Throwable> predicate) {
            this.retryExceptionPredicate = predicate;
            return this;
        }

        @SafeVarargs
        public final Builder retryExceptions(Class<? extends Throwable> ... errorClasses) {
            this.retryExceptions = errorClasses != null ? errorClasses : new Class[]{};
            return this;
        }

        @SafeVarargs
        public final Builder ignoreExceptions(Class<? extends Throwable> ... errorClasses) {
            this.ignoreExceptions = errorClasses != null ? errorClasses : new Class[]{};
            return this;
        }

        public RetryConfig build() {
            this.buildExceptionPredicate();
            RetryConfig config = new RetryConfig();
            config.intervalFunction = this.intervalFunction;
            config.maxAttempts = this.maxAttempts;
            config.exceptionPredicate = this.exceptionPredicate;
            return config;
        }

        private void buildExceptionPredicate() {
            this.exceptionPredicate = this.getRetryPredicate().and(this.buildIgnoreExceptionsPredicate().orElse(DEFAULT_RECORD_FAILURE_PREDICATE));
        }

        private Predicate<Throwable> getRetryPredicate() {
            return this.buildRetryExceptionsPredicate().map(predicate -> this.retryExceptionPredicate != null ? predicate.or(this.retryExceptionPredicate) : predicate).orElseGet(() -> this.retryExceptionPredicate != null ? this.retryExceptionPredicate : DEFAULT_RECORD_FAILURE_PREDICATE);
        }

        private Optional<Predicate<Throwable>> buildRetryExceptionsPredicate() {
            return Arrays.stream(this.retryExceptions).distinct().map(Builder::makePredicate).reduce(Predicate::or);
        }

        private Optional<Predicate<Throwable>> buildIgnoreExceptionsPredicate() {
            return Arrays.stream(this.ignoreExceptions).distinct().map(Builder::makePredicate).reduce(Predicate::or).map(Predicate::negate);
        }

        static Predicate<Throwable> makePredicate(Class<? extends Throwable> exClass) {
            return e -> exClass.isAssignableFrom(e.getClass());
        }
    }
}

