/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry;

import io.github.resilience4j.retry.IntervalFunction;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Predicate;

public class RetryConfig {
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    public static final long DEFAULT_WAIT_DURATION = 500L;
    private int maxAttempts = 3;
    private IntervalFunction intervalFunction = numOfAttempts -> 500L;
    private Predicate<Throwable> exceptionPredicate = exception -> true;

    private RetryConfig() {
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public Function<Integer, Long> getIntervalFunction() {
        return this.intervalFunction;
    }

    public Predicate<Throwable> getExceptionPredicate() {
        return this.exceptionPredicate;
    }

    public static Builder custom() {
        return new Builder();
    }

    public static RetryConfig ofDefaults() {
        return new Builder().build();
    }

    public static class Builder {
        private RetryConfig config = new RetryConfig();

        public Builder maxAttempts(int maxAttempts) {
            if (maxAttempts < 1) {
                throw new IllegalArgumentException("maxAttempts must be greater than or equal to 1");
            }
            this.config.maxAttempts = maxAttempts;
            return this;
        }

        public Builder waitDuration(Duration waitDuration) {
            if (waitDuration.toMillis() < 10L) {
                throw new IllegalArgumentException("waitDurationInOpenState must be at least 10ms");
            }
            this.config.intervalFunction = x -> waitDuration.toMillis();
            return this;
        }

        public Builder intervalFunction(IntervalFunction f) {
            this.config.intervalFunction = f;
            return this;
        }

        public Builder retryOnException(Predicate<Throwable> predicate) {
            this.config.exceptionPredicate = predicate;
            return this;
        }

        public RetryConfig build() {
            return this.config;
        }
    }
}

