/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.micrometer.operator;

import io.github.resilience4j.micrometer.Timer;
import io.github.resilience4j.reactor.IllegalPublisherException;
import io.github.resilience4j.reactor.micrometer.operator.FluxTimer;
import io.github.resilience4j.reactor.micrometer.operator.MonoTimer;
import java.util.function.UnaryOperator;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TimerOperator<T>
implements UnaryOperator<Publisher<T>> {
    private final Timer timer;

    private TimerOperator(Timer timer) {
        this.timer = timer;
    }

    public static <T> TimerOperator<T> of(Timer timer) {
        return new TimerOperator<T>(timer);
    }

    @Override
    public Publisher<T> apply(Publisher<T> publisher) {
        if (publisher instanceof Mono) {
            return new MonoTimer((Mono)publisher, this.timer);
        }
        if (publisher instanceof Flux) {
            return new FluxTimer((Flux)publisher, this.timer);
        }
        throw new IllegalPublisherException(publisher);
    }
}

