/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.ratelimiter.operator;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.reactor.IllegalPublisherException;
import io.github.resilience4j.reactor.ratelimiter.operator.FluxRateLimiter;
import io.github.resilience4j.reactor.ratelimiter.operator.MonoRateLimiter;
import java.util.function.UnaryOperator;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RateLimiterOperator<T>
implements UnaryOperator<Publisher<T>> {
    private final RateLimiter rateLimiter;
    private final int permits;

    private RateLimiterOperator(RateLimiter rateLimiter, int permits) {
        this.rateLimiter = rateLimiter;
        this.permits = permits;
    }

    public static <T> RateLimiterOperator<T> of(RateLimiter rateLimiter) {
        return new RateLimiterOperator<T>(rateLimiter, 1);
    }

    public static <T> RateLimiterOperator<T> of(RateLimiter rateLimiter, int permits) {
        return new RateLimiterOperator<T>(rateLimiter, permits);
    }

    @Override
    public Publisher<T> apply(Publisher<T> publisher) {
        if (publisher instanceof Mono) {
            return new MonoRateLimiter((Mono)publisher, this.rateLimiter, this.permits);
        }
        if (publisher instanceof Flux) {
            return new FluxRateLimiter((Flux)publisher, this.rateLimiter, this.permits);
        }
        throw new IllegalPublisherException(publisher);
    }
}

