/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.retry;

import io.github.resilience4j.reactor.IllegalPublisherException;
import io.github.resilience4j.reactor.retry.RetryExceptionWrapper;
import io.github.resilience4j.retry.Retry;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RetryOperator<T>
implements UnaryOperator<Publisher<T>> {
    private final Retry retry;

    private RetryOperator(Retry retry) {
        this.retry = retry;
    }

    public static <T> RetryOperator<T> of(Retry retry) {
        return new RetryOperator<T>(retry);
    }

    private static <T> Consumer<T> throwingConsumerWrapper(ThrowingConsumer<T, Exception> throwingConsumer) {
        return i -> {
            try {
                throwingConsumer.accept(i);
            }
            catch (Exception ex) {
                throw new RetryExceptionWrapper(ex);
            }
        };
    }

    @Override
    public Publisher<T> apply(Publisher<T> publisher) {
        if (publisher instanceof Mono) {
            Context context = new Context(this.retry.context());
            Mono upstream = (Mono)publisher;
            return upstream.doOnNext(context::throwExceptionToForceRetryOnResult).retryWhen(errors -> errors.doOnNext(RetryOperator.throwingConsumerWrapper(context::onError))).doOnSuccess(t -> context.onComplete());
        }
        if (publisher instanceof Flux) {
            Context context = new Context(this.retry.context());
            Flux upstream = (Flux)publisher;
            return upstream.doOnNext(context::throwExceptionToForceRetryOnResult).retryWhen(errors -> errors.doOnNext(RetryOperator.throwingConsumerWrapper(context::onError))).doOnComplete(context::onComplete);
        }
        throw new IllegalPublisherException(publisher);
    }

    private static class Context<T> {
        private final Retry.Context<T> context;

        Context(Retry.Context<T> context) {
            this.context = context;
        }

        void onComplete() {
            this.context.onComplete();
        }

        void throwExceptionToForceRetryOnResult(T value) {
            if (this.context.onResult(value)) {
                throw new RetryDueToResultException();
            }
        }

        void onError(Throwable throwable) throws Exception {
            if (throwable instanceof RetryDueToResultException) {
                return;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            try {
                if (throwable instanceof RetryExceptionWrapper) {
                    this.context.onError(this.castToException(throwable.getCause()));
                } else {
                    this.context.onError(this.castToException(throwable));
                }
            }
            catch (Throwable t) {
                throw this.castToException(t);
            }
        }

        private Exception castToException(Throwable throwable) {
            return throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
        }

        private static class RetryDueToResultException
        extends RuntimeException {
            RetryDueToResultException() {
                super("retry due to retryOnResult predicate");
            }
        }
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }
}

