/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.circuitbreaker.operator;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.core.StopWatch;
import io.github.resilience4j.reactor.AbstractSubscriber;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import reactor.core.CoreSubscriber;

class CircuitBreakerSubscriber<T>
extends AbstractSubscriber<T> {
    private final CircuitBreaker circuitBreaker;
    private final StopWatch stopWatch;
    private final boolean singleProducer;
    private volatile int successSignaled = 0;
    private static final AtomicIntegerFieldUpdater<CircuitBreakerSubscriber> SUCCESS_SIGNALED = AtomicIntegerFieldUpdater.newUpdater(CircuitBreakerSubscriber.class, "successSignaled");

    protected CircuitBreakerSubscriber(CircuitBreaker circuitBreaker, CoreSubscriber<? super T> downstreamSubscriber, boolean singleProducer) {
        super(downstreamSubscriber);
        this.circuitBreaker = Objects.requireNonNull(circuitBreaker);
        this.singleProducer = singleProducer;
        this.stopWatch = StopWatch.start();
    }

    protected void hookOnNext(T value) {
        if (!this.isDisposed()) {
            if (this.singleProducer && SUCCESS_SIGNALED.compareAndSet(this, 0, 1)) {
                this.circuitBreaker.onSuccess(this.stopWatch.stop().toNanos());
            }
            this.downstreamSubscriber.onNext(value);
        }
    }

    protected void hookOnComplete() {
        if (SUCCESS_SIGNALED.compareAndSet(this, 0, 1)) {
            this.circuitBreaker.onSuccess(this.stopWatch.stop().toNanos());
        }
        this.downstreamSubscriber.onComplete();
    }

    public void hookOnCancel() {
        if (this.successSignaled == 0) {
            this.circuitBreaker.releasePermission();
        }
    }

    protected void hookOnError(Throwable e) {
        this.circuitBreaker.onError(this.stopWatch.stop().toNanos(), e);
        this.downstreamSubscriber.onError(e);
    }
}

