/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.ratelimiter.operator;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.github.resilience4j.reactor.ResilienceBaseSubscriber;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import reactor.core.CoreSubscriber;

class RateLimiterSubscriber<T>
extends ResilienceBaseSubscriber<T> {
    private final RateLimiter rateLimiter;
    private final AtomicBoolean firstEvent = new AtomicBoolean(true);

    public RateLimiterSubscriber(RateLimiter rateLimiter, CoreSubscriber<? super T> actual) {
        super(actual);
        this.rateLimiter = Objects.requireNonNull(rateLimiter);
    }

    @Override
    public void hookOnNext(T t) {
        if (this.notCancelled() && this.wasCallPermitted()) {
            if (this.firstEvent.getAndSet(false) || this.rateLimiter.getPermission(this.rateLimiter.getRateLimiterConfig().getTimeoutDuration())) {
                this.actual.onNext(t);
            } else {
                this.cancel();
                this.actual.onError((Throwable)this.rateLimitExceededException());
            }
        }
    }

    @Override
    public void hookOnError(Throwable t) {
        if (this.wasCallPermitted()) {
            this.actual.onError(t);
        }
    }

    @Override
    protected boolean isCallPermitted() {
        return this.rateLimiter.getPermission(this.rateLimiter.getRateLimiterConfig().getTimeoutDuration());
    }

    @Override
    protected Throwable getThrowable() {
        return this.rateLimitExceededException();
    }

    @Override
    public void hookOnComplete() {
        if (this.wasCallPermitted()) {
            this.actual.onComplete();
        }
    }

    private Exception rateLimitExceededException() {
        return new RequestNotPermitted("Request not permitted for limiter: " + this.rateLimiter.getName());
    }
}

