/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.bulkhead.operator;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.reactor.ResilienceBaseSubscriber;
import java.util.Objects;
import reactor.core.CoreSubscriber;

class BulkheadSubscriber<T>
extends ResilienceBaseSubscriber<T> {
    private final Bulkhead bulkhead;

    public BulkheadSubscriber(Bulkhead bulkhead, CoreSubscriber<? super T> actual) {
        super(actual);
        this.bulkhead = Objects.requireNonNull(bulkhead);
    }

    @Override
    public void hookOnNext(T t) {
        if (this.notCancelled() && this.wasCallPermitted()) {
            this.actual.onNext(t);
        }
    }

    @Override
    public void hookOnError(Throwable t) {
        if (this.wasCallPermitted()) {
            this.bulkhead.onComplete();
            this.actual.onError(t);
        }
    }

    @Override
    protected boolean isCallPermitted() {
        return this.bulkhead.isCallPermitted();
    }

    @Override
    protected Throwable getThrowable() {
        return new BulkheadFullException(String.format("Bulkhead '%s' is full", this.bulkhead.getName()));
    }

    @Override
    public void hookOnComplete() {
        if (this.wasCallPermitted()) {
            this.releaseBulkhead();
            this.actual.onComplete();
        }
    }

    private void releaseBulkhead() {
        if (this.wasCallPermitted()) {
            this.bulkhead.onComplete();
        }
    }
}

