/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.bulkhead.operator;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.reactor.FluxResilience;
import io.github.resilience4j.reactor.MonoResilience;
import io.github.resilience4j.reactor.bulkhead.operator.FluxBulkhead;
import io.github.resilience4j.reactor.bulkhead.operator.MonoBulkhead;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class BulkheadOperator<T>
implements Function<Publisher<T>, Publisher<T>> {
    private final Bulkhead bulkhead;
    private final Scheduler scheduler;

    private BulkheadOperator(Bulkhead bulkhead, Scheduler scheduler) {
        this.bulkhead = bulkhead;
        this.scheduler = scheduler;
    }

    public static <T> BulkheadOperator<T> of(Bulkhead bulkhead) {
        return BulkheadOperator.of(bulkhead, Schedulers.parallel());
    }

    public static <T> BulkheadOperator<T> of(Bulkhead bulkhead, Scheduler scheduler) {
        return new BulkheadOperator<T>(bulkhead, scheduler);
    }

    @Override
    public Publisher<T> apply(Publisher<T> publisher) {
        if (publisher instanceof Mono) {
            return MonoResilience.onAssembly(new MonoBulkhead((Mono)publisher, this.bulkhead, this.scheduler));
        }
        if (publisher instanceof Flux) {
            return FluxResilience.onAssembly(new FluxBulkhead((Flux)publisher, this.bulkhead, this.scheduler));
        }
        throw new IllegalStateException("Publisher of type <" + publisher.getClass().getSimpleName() + "> are not supported by this operator");
    }
}

