/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor;

import io.github.resilience4j.reactor.Permit;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SignalType;
import reactor.util.context.Context;

public abstract class ResilienceBaseSubscriber<T>
implements CoreSubscriber<T>,
Subscription,
Disposable {
    protected final CoreSubscriber<? super T> actual;
    private volatile Subscription subscription;
    private static final AtomicReferenceFieldUpdater<ResilienceBaseSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(ResilienceBaseSubscriber.class, Subscription.class, "subscription");
    private final AtomicReference<Permit> permitted = new AtomicReference<Permit>(Permit.PENDING);

    protected ResilienceBaseSubscriber(CoreSubscriber<? super T> actual) {
        this.actual = actual;
    }

    protected Subscription upstream() {
        return this.subscription;
    }

    public boolean isDisposed() {
        return this.subscription == Operators.cancelledSubscription();
    }

    public void dispose() {
        this.cancel();
    }

    public Context currentContext() {
        return this.actual.currentContext();
    }

    protected boolean notCancelled() {
        return !this.isDisposed();
    }

    protected void hookOnSubscribe(Subscription subscription) {
    }

    protected void hookOnNext(T value) {
    }

    protected void hookOnComplete() {
    }

    protected void hookOnError(Throwable throwable) {
        throw Exceptions.errorCallbackNotImplemented((Throwable)throwable);
    }

    protected void hookOnCancel() {
    }

    protected void hookFinally(SignalType type) {
    }

    protected void hookOnPermitAcquired() {
    }

    protected abstract boolean isCallPermitted();

    protected boolean acquireCallPermit() {
        boolean callPermitted = false;
        if (this.permitted.compareAndSet(Permit.PENDING, Permit.ACQUIRED)) {
            callPermitted = this.isCallPermitted();
            if (!callPermitted) {
                this.permitted.set(Permit.REJECTED);
            } else {
                this.hookOnPermitAcquired();
            }
        }
        return callPermitted;
    }

    protected boolean wasCallPermitted() {
        return this.permitted.get() == Permit.ACQUIRED;
    }

    protected abstract Throwable getThrowable();

    public final void onSubscribe(Subscription s) {
        if (Operators.setOnce(S, (Object)this, (Subscription)s)) {
            try {
                this.hookOnSubscribe(s);
                if (this.acquireCallPermit()) {
                    this.actual.onSubscribe((Subscription)this);
                } else {
                    this.cancel();
                    this.actual.onSubscribe((Subscription)this);
                    this.actual.onError(this.getThrowable());
                }
            }
            catch (Throwable throwable) {
                this.onError(Operators.onOperatorError((Subscription)s, (Throwable)throwable, (Context)this.currentContext()));
            }
        }
    }

    public final void onNext(T value) {
        Objects.requireNonNull(value, "onNext");
        try {
            this.hookOnNext(value);
        }
        catch (Throwable throwable) {
            this.onError(Operators.onOperatorError((Subscription)this.subscription, (Throwable)throwable, value, (Context)this.currentContext()));
        }
    }

    public final void onError(Throwable t) {
        Objects.requireNonNull(t, "onError");
        if (S.getAndSet(this, Operators.cancelledSubscription()) == Operators.cancelledSubscription()) {
            if (this.permitted.get() == Permit.REJECTED) {
                return;
            }
            Operators.onErrorDropped((Throwable)t, (Context)this.currentContext());
            return;
        }
        try {
            this.hookOnError(t);
        }
        catch (Throwable e) {
            e = Exceptions.addSuppressed((Throwable)e, (Throwable)t);
            Operators.onErrorDropped((Throwable)e, (Context)this.currentContext());
        }
        finally {
            this.safeHookFinally(SignalType.ON_ERROR);
        }
    }

    public final void onComplete() {
        if (S.getAndSet(this, Operators.cancelledSubscription()) != Operators.cancelledSubscription()) {
            try {
                this.hookOnComplete();
            }
            catch (Throwable throwable) {
                this.hookOnError(Operators.onOperatorError((Throwable)throwable, (Context)this.currentContext()));
            }
            finally {
                this.safeHookFinally(SignalType.ON_COMPLETE);
            }
        }
    }

    public final void request(long n) {
        Subscription s;
        if (Operators.validate((long)n) && (s = this.subscription) != null) {
            s.request(n);
        }
    }

    public final void requestUnbounded() {
        this.request(Long.MAX_VALUE);
    }

    public final void cancel() {
        if (Operators.terminate(S, (Object)this)) {
            try {
                this.hookOnCancel();
            }
            catch (Throwable throwable) {
                this.hookOnError(Operators.onOperatorError((Subscription)this.subscription, (Throwable)throwable, (Context)this.currentContext()));
            }
            finally {
                this.safeHookFinally(SignalType.CANCEL);
            }
        }
    }

    private void safeHookFinally(SignalType type) {
        try {
            this.hookFinally(type);
        }
        catch (Throwable finallyFailure) {
            Operators.onErrorDropped((Throwable)finallyFailure, (Context)this.currentContext());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

