/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.circuitbreaker.operator;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerOpenException;
import io.github.resilience4j.core.StopWatch;
import io.github.resilience4j.reactor.Permit;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;

class CircuitBreakerSubscriber<T>
extends BaseSubscriber<T> {
    private final CoreSubscriber<? super T> actual;
    private final CircuitBreaker circuitBreaker;
    private final AtomicReference<Permit> permitted = new AtomicReference<Permit>(Permit.PENDING);
    private StopWatch stopWatch;

    public CircuitBreakerSubscriber(CircuitBreaker circuitBreaker, CoreSubscriber<? super T> actual) {
        this.actual = actual;
        this.circuitBreaker = Objects.requireNonNull(circuitBreaker);
    }

    protected void hookOnSubscribe(Subscription subscription) {
        if (this.acquireCallPermit()) {
            this.actual.onSubscribe((Subscription)this);
        } else {
            this.cancel();
            this.actual.onSubscribe((Subscription)this);
            this.actual.onError((Throwable)new CircuitBreakerOpenException(String.format("CircuitBreaker '%s' is open", this.circuitBreaker.getName())));
        }
    }

    protected void hookOnNext(T value) {
        if (this.notCancelled() && this.wasCallPermitted()) {
            this.actual.onNext(value);
        }
    }

    protected void hookOnComplete() {
        this.markSuccess();
        if (this.wasCallPermitted()) {
            this.actual.onComplete();
        }
    }

    protected void hookOnError(Throwable t) {
        Objects.requireNonNull(t);
        this.markFailure(t);
        if (this.wasCallPermitted()) {
            this.actual.onError(t);
        }
    }

    private boolean acquireCallPermit() {
        boolean callPermitted = false;
        if (this.permitted.compareAndSet(Permit.PENDING, Permit.ACQUIRED)) {
            callPermitted = this.circuitBreaker.isCallPermitted();
            if (!callPermitted) {
                this.permitted.set(Permit.REJECTED);
            } else {
                this.stopWatch = StopWatch.start((String)this.circuitBreaker.getName());
            }
        }
        return callPermitted;
    }

    private void markFailure(Throwable e) {
        if (this.wasCallPermitted()) {
            this.circuitBreaker.onError(this.stopWatch.stop().getProcessingDuration().toNanos(), e);
        }
    }

    private void markSuccess() {
        if (this.wasCallPermitted()) {
            this.circuitBreaker.onSuccess(this.stopWatch.stop().getProcessingDuration().toNanos());
        }
    }

    private boolean notCancelled() {
        return !this.isDisposed();
    }

    private boolean wasCallPermitted() {
        return this.permitted.get() == Permit.ACQUIRED;
    }
}

