/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.internal;

import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.registry.AbstractRegistry;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.internal.AtomicRateLimiter;
import io.vavr.collection.Array;
import io.vavr.collection.Seq;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class InMemoryRateLimiterRegistry
extends AbstractRegistry<RateLimiter, RateLimiterConfig>
implements RateLimiterRegistry {
    public InMemoryRateLimiterRegistry() {
        this(RateLimiterConfig.ofDefaults());
    }

    public InMemoryRateLimiterRegistry(Map<String, RateLimiterConfig> configs) {
        this(configs.getOrDefault("default", RateLimiterConfig.ofDefaults()));
        this.configurations.putAll(configs);
    }

    public InMemoryRateLimiterRegistry(RateLimiterConfig defaultConfig) {
        super((Object)defaultConfig);
    }

    @Override
    public Seq<RateLimiter> getAllRateLimiters() {
        return Array.ofAll(this.entryMap.values());
    }

    @Override
    public RateLimiter rateLimiter(String name) {
        return this.rateLimiter(name, (RateLimiterConfig)this.getDefaultConfig());
    }

    @Override
    public RateLimiter rateLimiter(String name, RateLimiterConfig config) {
        return (RateLimiter)this.computeIfAbsent(name, () -> new AtomicRateLimiter(name, Objects.requireNonNull(config, "Config must not be null")));
    }

    @Override
    public RateLimiter rateLimiter(String name, Supplier<RateLimiterConfig> rateLimiterConfigSupplier) {
        return (RateLimiter)this.computeIfAbsent(name, () -> new AtomicRateLimiter(name, (RateLimiterConfig)Objects.requireNonNull(Objects.requireNonNull(rateLimiterConfigSupplier, "Supplier must not be null").get(), "Config must not be null")));
    }

    @Override
    public RateLimiter rateLimiter(String name, String configName) {
        return (RateLimiter)this.computeIfAbsent(name, () -> RateLimiter.of(name, (RateLimiterConfig)this.getConfiguration(configName).orElseThrow(() -> new ConfigurationNotFoundException(configName))));
    }
}

