/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micronaut.timelimiter;

import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.timelimiter.configuration.CommonTimeLimiterConfigurationProperties;
import io.github.resilience4j.common.timelimiter.configuration.TimeLimiterConfigCustomizer;
import io.github.resilience4j.consumer.DefaultEventConsumerRegistry;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.core.registry.CompositeRegistryEventConsumer;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.micronaut.timelimiter.TimeLimiterQualifier;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import io.github.resilience4j.timelimiter.event.TimeLimiterEvent;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Factory
@Requires(property="resilience4j.timelimiter.enabled", value="true", defaultValue="false")
public class TimeLimiterRegistryFactory {
    @Bean
    @TimeLimiterQualifier
    public CompositeCustomizer<TimeLimiterConfigCustomizer> compositeTimeLimiterCustomizer(@Nullable List<TimeLimiterConfigCustomizer> configCustomizers) {
        return new CompositeCustomizer(configCustomizers);
    }

    @Singleton
    @Requires(beans={CommonTimeLimiterConfigurationProperties.class})
    public TimeLimiterRegistry timeLimiterRegistry(CommonTimeLimiterConfigurationProperties timeLimiterConfigurationProperties, @TimeLimiterQualifier EventConsumerRegistry<TimeLimiterEvent> timeLimiterEventConsumerRegistry, @TimeLimiterQualifier RegistryEventConsumer<TimeLimiter> timeLimiterRegistryEventConsumer, @TimeLimiterQualifier CompositeCustomizer<TimeLimiterConfigCustomizer> compositeTimeLimiterCustomizer) {
        TimeLimiterRegistry timeLimiterRegistry = TimeLimiterRegistryFactory.createTimeLimiterRegistry(timeLimiterConfigurationProperties, timeLimiterRegistryEventConsumer, compositeTimeLimiterCustomizer);
        TimeLimiterRegistryFactory.registerEventConsumer(timeLimiterRegistry, timeLimiterEventConsumerRegistry, timeLimiterConfigurationProperties);
        this.initTimeLimiterRegistry(timeLimiterRegistry, timeLimiterConfigurationProperties, compositeTimeLimiterCustomizer);
        return timeLimiterRegistry;
    }

    @Bean
    @Primary
    @TimeLimiterQualifier
    public RegistryEventConsumer<TimeLimiter> timeLimiterRegistryEventConsumer(Optional<List<RegistryEventConsumer<TimeLimiter>>> optionalRegistryEventConsumers) {
        return new CompositeRegistryEventConsumer(optionalRegistryEventConsumers.orElseGet(ArrayList::new));
    }

    @Bean
    @TimeLimiterQualifier
    public EventConsumerRegistry<TimeLimiterEvent> timeLimiterEventsConsumerRegistry() {
        return new DefaultEventConsumerRegistry();
    }

    void initTimeLimiterRegistry(TimeLimiterRegistry timeLimiterRegistry, CommonTimeLimiterConfigurationProperties timeLimiterConfigurationProperties, CompositeCustomizer<TimeLimiterConfigCustomizer> compositeTimeLimiterCustomizer) {
        timeLimiterConfigurationProperties.getInstances().forEach((name, properties) -> timeLimiterRegistry.timeLimiter(name, timeLimiterConfigurationProperties.createTimeLimiterConfig(name, properties, compositeTimeLimiterCustomizer)));
    }

    private static TimeLimiterRegistry createTimeLimiterRegistry(CommonTimeLimiterConfigurationProperties timeLimiterConfigurationProperties, RegistryEventConsumer<TimeLimiter> timeLimiterRegistryEventConsumer, CompositeCustomizer<TimeLimiterConfigCustomizer> compositeTimeLimiterCustomizer) {
        Map<String, TimeLimiterConfig> configs = timeLimiterConfigurationProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> timeLimiterConfigurationProperties.createTimeLimiterConfig((String)entry.getKey(), (CommonTimeLimiterConfigurationProperties.InstanceProperties)entry.getValue(), compositeTimeLimiterCustomizer)));
        return TimeLimiterRegistry.of(configs, timeLimiterRegistryEventConsumer, (Map)timeLimiterConfigurationProperties.getTags());
    }

    private static void registerEventConsumer(TimeLimiterRegistry timeLimiterRegistry, EventConsumerRegistry<TimeLimiterEvent> eventConsumerRegistry, CommonTimeLimiterConfigurationProperties timeLimiterConfigurationProperties) {
        timeLimiterRegistry.getEventPublisher().onEntryAdded(event -> TimeLimiterRegistryFactory.registerEventConsumer(eventConsumerRegistry, (TimeLimiter)event.getAddedEntry(), timeLimiterConfigurationProperties));
    }

    private static void registerEventConsumer(EventConsumerRegistry<TimeLimiterEvent> eventConsumerRegistry, TimeLimiter timeLimiter, CommonTimeLimiterConfigurationProperties timeLimiterConfigurationProperties) {
        int eventConsumerBufferSize = Optional.ofNullable(timeLimiterConfigurationProperties.getInstanceProperties(timeLimiter.getName())).map(CommonTimeLimiterConfigurationProperties.InstanceProperties::getEventConsumerBufferSize).orElse(100);
        timeLimiter.getEventPublisher().onEvent((EventConsumer)eventConsumerRegistry.createEventConsumer(timeLimiter.getName(), eventConsumerBufferSize));
    }
}

