/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micronaut.ratelimiter;

import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.ratelimiter.configuration.CommonRateLimiterConfigurationProperties;
import io.github.resilience4j.common.ratelimiter.configuration.RateLimiterConfigCustomizer;
import io.github.resilience4j.consumer.DefaultEventConsumerRegistry;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.registry.CompositeRegistryEventConsumer;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.micronaut.ratelimiter.RateLimiterProperties;
import io.github.resilience4j.micronaut.ratelimiter.RateLimiterQualifier;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.event.RateLimiterEvent;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@Factory
@Requires(property="resilience4j.ratelimiter.enabled", value="true", defaultValue="false")
public class RateLimiterRegistryFactory {
    @Bean
    @RateLimiterQualifier
    public CompositeCustomizer<RateLimiterConfigCustomizer> compositeRateLimiterCustomizer(@Nullable List<RateLimiterConfigCustomizer> configCustomizers) {
        return new CompositeCustomizer(configCustomizers);
    }

    @Singleton
    public RateLimiterRegistry rateLimiterRegistry(RateLimiterProperties rateLimiterProperties, @RateLimiterQualifier EventConsumerRegistry<RateLimiterEvent> rateLimiterEventsConsumerRegistry, @RateLimiterQualifier RegistryEventConsumer<RateLimiter> rateLimiterRegistryEventConsumer, @RateLimiterQualifier CompositeCustomizer<RateLimiterConfigCustomizer> compositeRateLimiterCustomizer) {
        RateLimiterRegistry rateLimiterRegistry = this.createRateLimiterRegistry(rateLimiterProperties, rateLimiterRegistryEventConsumer, compositeRateLimiterCustomizer);
        this.registerEventConsumer(rateLimiterRegistry, rateLimiterEventsConsumerRegistry, (CommonRateLimiterConfigurationProperties)rateLimiterProperties);
        rateLimiterProperties.getInstances().forEach((name, properites) -> rateLimiterRegistry.rateLimiter(name, rateLimiterProperties.createRateLimiterConfig((CommonRateLimiterConfigurationProperties.InstanceProperties)properites, (CompositeCustomizer)compositeRateLimiterCustomizer, (String)name)));
        return rateLimiterRegistry;
    }

    @Bean
    @RateLimiterQualifier
    public EventConsumerRegistry<RateLimiterEvent> rateLimiterEventEventConsumerRegistry() {
        return new DefaultEventConsumerRegistry();
    }

    @Bean
    @Primary
    @RateLimiterQualifier
    public RegistryEventConsumer<RateLimiter> rateLimiterRegistryEventConsumer(Optional<List<RegistryEventConsumer<RateLimiter>>> optionalRegistryEventConsumers) {
        return new CompositeRegistryEventConsumer(optionalRegistryEventConsumers.orElseGet(ArrayList::new));
    }

    private void registerEventConsumer(RateLimiterRegistry rateLimiterRegistry, EventConsumerRegistry<RateLimiterEvent> eventConsumerRegistry, CommonRateLimiterConfigurationProperties rateLimiterConfigurationProperties) {
        rateLimiterRegistry.getEventPublisher().onEntryAdded(event -> this.registerEventConsumer(eventConsumerRegistry, (RateLimiter)event.getAddedEntry(), rateLimiterConfigurationProperties));
    }

    private void registerEventConsumer(EventConsumerRegistry<RateLimiterEvent> eventConsumerRegistry, RateLimiter rateLimiter, CommonRateLimiterConfigurationProperties rateLimiterConfigurationProperties) {
        CommonRateLimiterConfigurationProperties.InstanceProperties limiterProperties = (CommonRateLimiterConfigurationProperties.InstanceProperties)rateLimiterConfigurationProperties.getInstances().get(rateLimiter.getName());
        if (limiterProperties != null && limiterProperties.getSubscribeForEvents() != null && limiterProperties.getSubscribeForEvents().booleanValue()) {
            rateLimiter.getEventPublisher().onEvent((EventConsumer)eventConsumerRegistry.createEventConsumer(rateLimiter.getName(), limiterProperties.getEventConsumerBufferSize() != null && limiterProperties.getEventConsumerBufferSize() != 0 ? limiterProperties.getEventConsumerBufferSize() : 100));
        }
    }

    private RateLimiterRegistry createRateLimiterRegistry(CommonRateLimiterConfigurationProperties rateLimiterConfigurationProperties, RegistryEventConsumer<RateLimiter> rateLimiterRegistryEventConsumer, CompositeCustomizer<RateLimiterConfigCustomizer> compositeRateLimiterCustomizer) {
        Map<String, RateLimiterConfig> configs = rateLimiterConfigurationProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> rateLimiterConfigurationProperties.createRateLimiterConfig((CommonRateLimiterConfigurationProperties.InstanceProperties)entry.getValue(), compositeRateLimiterCustomizer, (String)entry.getKey())));
        return RateLimiterRegistry.of(configs, rateLimiterRegistryEventConsumer, (Map)rateLimiterConfigurationProperties.getTags());
    }
}

