/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micronaut.circuitbreaker;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.micronaut.BaseInterceptor;
import io.github.resilience4j.micronaut.ResilienceInterceptPhase;
import io.github.resilience4j.micronaut.util.PublisherExtension;
import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.annotation.Requires;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.MethodExecutionHandle;
import jakarta.inject.Singleton;
import java.util.Optional;
import java.util.concurrent.CompletionException;

@Singleton
@Requires(beans={CircuitBreakerRegistry.class})
public class CircuitBreakerInterceptor
extends BaseInterceptor
implements MethodInterceptor<Object, Object> {
    private final CircuitBreakerRegistry circuitBreakerRegistry;
    private final ExecutionHandleLocator executionHandleLocator;
    private final PublisherExtension extension;

    public CircuitBreakerInterceptor(ExecutionHandleLocator executionHandleLocator, CircuitBreakerRegistry circuitBreakerRegistry, PublisherExtension extension) {
        this.circuitBreakerRegistry = circuitBreakerRegistry;
        this.executionHandleLocator = executionHandleLocator;
        this.extension = extension;
    }

    public int getOrder() {
        return ResilienceInterceptPhase.CIRCUIT_BREAKER.getPosition();
    }

    @Override
    public Optional<? extends MethodExecutionHandle<?, Object>> findFallbackMethod(MethodInvocationContext<Object, Object> context) {
        ExecutableMethod executableMethod = context.getExecutableMethod();
        String fallbackMethod = executableMethod.stringValue(io.github.resilience4j.micronaut.annotation.CircuitBreaker.class, "fallbackMethod").orElse("");
        Class declaringType = context.getDeclaringType();
        return this.executionHandleLocator.findExecutionHandle(declaringType, fallbackMethod, context.getArgumentTypes());
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        Optional opt = context.findAnnotation(io.github.resilience4j.micronaut.annotation.CircuitBreaker.class);
        if (!opt.isPresent()) {
            return context.proceed();
        }
        ExecutableMethod executableMethod = context.getExecutableMethod();
        String name = executableMethod.stringValue(io.github.resilience4j.micronaut.annotation.CircuitBreaker.class, "name").orElse("default");
        CircuitBreaker circuitBreaker = this.circuitBreakerRegistry.circuitBreaker(name);
        InterceptedMethod interceptedMethod = InterceptedMethod.of(context);
        try {
            switch (interceptedMethod.resultType()) {
                case PUBLISHER: {
                    return interceptedMethod.handleResult(this.extension.fallbackPublisher(this.extension.circuitBreaker(interceptedMethod.interceptResultAsPublisher(), circuitBreaker), context, this::findFallbackMethod));
                }
                case COMPLETION_STAGE: {
                    return interceptedMethod.handleResult(this.fallbackForFuture(circuitBreaker.executeCompletionStage(() -> {
                        try {
                            return interceptedMethod.interceptResultAsCompletionStage();
                        }
                        catch (Exception e) {
                            throw new CompletionException(e);
                        }
                    }), context));
                }
                case SYNCHRONOUS: {
                    try {
                        return circuitBreaker.executeCheckedSupplier(() -> context.proceed());
                    }
                    catch (Throwable exception) {
                        return this.fallback(context, exception);
                    }
                }
            }
            return interceptedMethod.unsupported();
        }
        catch (Exception e) {
            return interceptedMethod.handleException(e);
        }
    }
}

