/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.micrometer.tagged.AbstractMetrics;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

abstract class AbstractTimeLimiterMetrics
extends AbstractMetrics {
    private static final String KIND_FAILED = "failed";
    private static final String KIND_SUCCESSFUL = "successful";
    private static final String KIND_TIMEOUT = "timeout";
    protected final MetricNames names;

    protected AbstractTimeLimiterMetrics(MetricNames names) {
        this.names = Objects.requireNonNull(names);
    }

    protected void addMetrics(MeterRegistry meterRegistry, TimeLimiter timeLimiter) {
        Counter successes = Counter.builder((String)this.names.getCallsMetricName()).description("The number of successful calls").tag("name", timeLimiter.getName()).tag("kind", KIND_SUCCESSFUL).register(meterRegistry);
        Counter failures = Counter.builder((String)this.names.getCallsMetricName()).description("The number of failed calls").tag("name", timeLimiter.getName()).tag("kind", KIND_FAILED).register(meterRegistry);
        Counter timeouts = Counter.builder((String)this.names.getCallsMetricName()).description("The number of timed out calls").tag("name", timeLimiter.getName()).tag("kind", KIND_TIMEOUT).register(meterRegistry);
        timeLimiter.getEventPublisher().onSuccess(event -> successes.increment()).onError(event -> failures.increment()).onTimeout(event -> timeouts.increment());
        List<Meter.Id> ids = Arrays.asList(successes.getId(), failures.getId(), timeouts.getId());
        this.meterIdMap.put(timeLimiter.getName(), new HashSet<Meter.Id>(ids));
    }

    public static class MetricNames {
        private static final String DEFAULT_PREFIX = "resilience4j.timelimiter";
        public static final String DEFAULT_TIME_LIMITER_CALLS = "resilience4j.timelimiter.calls";
        private String callsMetricName = "resilience4j.timelimiter.calls";

        public static Builder custom() {
            return new Builder();
        }

        public static MetricNames ofDefaults() {
            return new MetricNames();
        }

        public String getCallsMetricName() {
            return this.callsMetricName;
        }

        public static class Builder {
            private final MetricNames metricNames = new MetricNames();

            public Builder callsMetricName(String callsMetricName) {
                this.metricNames.callsMetricName = Objects.requireNonNull(callsMetricName);
                return this;
            }

            public MetricNames build() {
                return this.metricNames;
            }
        }
    }
}

