/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.micrometer.tagged.AbstractMetrics;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashSet;
import java.util.Objects;

abstract class AbstractRateLimiterMetrics
extends AbstractMetrics {
    protected final MetricNames names;

    protected AbstractRateLimiterMetrics(MetricNames names) {
        this.names = Objects.requireNonNull(names);
    }

    protected void addMetrics(MeterRegistry meterRegistry, RateLimiter rateLimiter) {
        HashSet<Meter.Id> idSet = new HashSet<Meter.Id>();
        idSet.add(Gauge.builder((String)this.names.getAvailablePermissionsMetricName(), (Object)rateLimiter, rl -> rl.getMetrics().getAvailablePermissions()).description("The number of available permissions").tag("name", rateLimiter.getName()).register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getWaitingThreadsMetricName(), (Object)rateLimiter, rl -> rl.getMetrics().getNumberOfWaitingThreads()).description("The number of waiting threads").tag("name", rateLimiter.getName()).register(meterRegistry).getId());
        this.meterIdMap.put(rateLimiter.getName(), idSet);
    }

    public static class MetricNames {
        private static final String DEFAULT_PREFIX = "resilience4j.ratelimiter";
        public static final String DEFAULT_AVAILABLE_PERMISSIONS_METRIC_NAME = "resilience4j.ratelimiter.available.permissions";
        public static final String DEFAULT_WAITING_THREADS_METRIC_NAME = "resilience4j.ratelimiter.waiting_threads";
        private String availablePermissionsMetricName = "resilience4j.ratelimiter.available.permissions";
        private String waitingThreadsMetricName = "resilience4j.ratelimiter.waiting_threads";

        public static Builder custom() {
            return new Builder();
        }

        public static MetricNames ofDefaults() {
            return new MetricNames();
        }

        public String getAvailablePermissionsMetricName() {
            return this.availablePermissionsMetricName;
        }

        public String getWaitingThreadsMetricName() {
            return this.waitingThreadsMetricName;
        }

        public static class Builder {
            private final MetricNames metricNames = new MetricNames();

            public Builder availablePermissionsMetricName(String availablePermissionsMetricName) {
                this.metricNames.availablePermissionsMetricName = Objects.requireNonNull(availablePermissionsMetricName);
                return this;
            }

            public Builder waitingThreadsMetricName(String waitingThreadsMetricName) {
                this.metricNames.waitingThreadsMetricName = Objects.requireNonNull(waitingThreadsMetricName);
                return this;
            }

            public MetricNames build() {
                return this.metricNames;
            }
        }
    }
}

