/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.micrometer.tagged.AbstractMetrics;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.HashSet;
import java.util.Objects;

public class TaggedRateLimiterMetrics
extends AbstractMetrics
implements MeterBinder {
    private final MetricNames names;
    private final RateLimiterRegistry rateLimiterRegistry;

    public static TaggedRateLimiterMetrics ofRateLimiterRegistry(RateLimiterRegistry rateLimiterRegistry) {
        return new TaggedRateLimiterMetrics(MetricNames.ofDefaults(), rateLimiterRegistry);
    }

    public static TaggedRateLimiterMetrics ofRateLimiterRegistry(MetricNames names, RateLimiterRegistry rateLimiterRegistry) {
        return new TaggedRateLimiterMetrics(names, rateLimiterRegistry);
    }

    private TaggedRateLimiterMetrics(MetricNames names, RateLimiterRegistry rateLimiterRegistry) {
        this.names = Objects.requireNonNull(names);
        this.rateLimiterRegistry = Objects.requireNonNull(rateLimiterRegistry);
    }

    public void bindTo(MeterRegistry registry) {
        for (RateLimiter rateLimiter : this.rateLimiterRegistry.getAllRateLimiters()) {
            this.addMetrics(registry, rateLimiter);
        }
        this.rateLimiterRegistry.getEventPublisher().onEntryAdded(event -> this.addMetrics(registry, (RateLimiter)event.getAddedEntry()));
        this.rateLimiterRegistry.getEventPublisher().onEntryRemoved(event -> this.removeMetrics(registry, ((RateLimiter)event.getRemovedEntry()).getName()));
        this.rateLimiterRegistry.getEventPublisher().onEntryReplaced(event -> {
            this.removeMetrics(registry, ((RateLimiter)event.getOldEntry()).getName());
            this.addMetrics(registry, (RateLimiter)event.getNewEntry());
        });
    }

    private void addMetrics(MeterRegistry registry, RateLimiter rateLimiter) {
        HashSet<Meter.Id> idSet = new HashSet<Meter.Id>();
        idSet.add(Gauge.builder((String)this.names.getAvailablePermissionsMetricName(), (Object)rateLimiter, rl -> rl.getMetrics().getAvailablePermissions()).description("The number of available permissions").tag("name", rateLimiter.getName()).register(registry).getId());
        idSet.add(Gauge.builder((String)this.names.getWaitingThreadsMetricName(), (Object)rateLimiter, rl -> rl.getMetrics().getNumberOfWaitingThreads()).description("The number of waiting threads").tag("name", rateLimiter.getName()).register(registry).getId());
        this.meterIdMap.put(rateLimiter.getName(), idSet);
    }

    public static class MetricNames {
        private static final String DEFAULT_PREFIX = "resilience4j.ratelimiter";
        public static final String DEFAULT_AVAILABLE_PERMISSIONS_METRIC_NAME = "resilience4j.ratelimiter.available.permissions";
        public static final String DEFAULT_WAITING_THREADS_METRIC_NAME = "resilience4j.ratelimiter.waiting_threads";
        private String availablePermissionsMetricName = "resilience4j.ratelimiter.available.permissions";
        private String waitingThreadsMetricName = "resilience4j.ratelimiter.waiting_threads";

        public static Builder custom() {
            return new Builder();
        }

        public static MetricNames ofDefaults() {
            return new MetricNames();
        }

        public String getAvailablePermissionsMetricName() {
            return this.availablePermissionsMetricName;
        }

        public String getWaitingThreadsMetricName() {
            return this.waitingThreadsMetricName;
        }

        public static class Builder {
            private final MetricNames metricNames = new MetricNames();

            public Builder availablePermissionsMetricName(String availablePermissionsMetricName) {
                this.metricNames.availablePermissionsMetricName = Objects.requireNonNull(availablePermissionsMetricName);
                return this;
            }

            public Builder waitingThreadsMetricName(String waitingThreadsMetricName) {
                this.metricNames.waitingThreadsMetricName = Objects.requireNonNull(waitingThreadsMetricName);
                return this;
            }

            public MetricNames build() {
                return this.metricNames;
            }
        }
    }
}

